/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event.synchronization;

import java.util.Map;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractSyncMailboxListener
implements EventListener {
    public static String getMailboxType() throws ClientException {
        CaseManagementDocumentTypeService correspDocumentTypeService;
        try {
            correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return correspDocumentTypeService.getMailboxType();
    }

    public static DocumentModel getMailboxDocument(Event event) throws ClientException {
        DocumentEventContext docEventContext = null;
        if (!(event.getContext() instanceof DocumentEventContext)) {
            throw new ClientException("Could not get Document from event");
        }
        docEventContext = (DocumentEventContext)event.getContext();
        return docEventContext.getSourceDocument();
    }

    public static String getMailboxType(Event event) {
        Map properties = event.getContext().getProperties();
        return (String)properties.get("eventContextMailboxType");
    }

    public static boolean isMailboxType(Event event, MailboxConstants.type type2) {
        String eventType = AbstractSyncMailboxListener.getMailboxType(event);
        return eventType != null && !"".equals(eventType) && eventType.equals(type2.name());
    }

    public static boolean isMailboxPersonal(Event event) {
        return AbstractSyncMailboxListener.isMailboxType(event, MailboxConstants.type.personal);
    }

    public static boolean isMailboxGeneric(Event event) {
        return AbstractSyncMailboxListener.isMailboxType(event, MailboxConstants.type.generic);
    }

    public static String getGroupUpdatePolicy(Event event) {
        Map properties = event.getContext().getProperties();
        return (String)properties.get("cm.onGroupDirectoryUpdate");
    }

    public static boolean isGroupUpdatePolicy(Event event, MailboxConstants.updatePolicy updatePolicy2) {
        String eventPolicy = AbstractSyncMailboxListener.getGroupUpdatePolicy(event);
        return eventPolicy != null && !"".equals(eventPolicy) && eventPolicy.equals(updatePolicy2.name());
    }
}

