/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.List;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.runtime.api.Framework;

public class CreateEmptyCaseUnrestricted
extends UnrestrictedSessionRunner {
    protected final String parentPath;
    protected final List<Mailbox> mailboxes;
    protected DocumentModel caseDoc;

    public CreateEmptyCaseUnrestricted(CoreSession session, DocumentModel caseDoc, String parentPath, List<Mailbox> mailbox) {
        super(session);
        this.caseDoc = caseDoc;
        this.mailboxes = mailbox;
        this.parentPath = parentPath;
    }

    public void run() throws ClientException {
        PathSegmentService pathSegmentService;
        try {
            pathSegmentService = (PathSegmentService)Framework.getService(PathSegmentService.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        String caseName = pathSegmentService.generatePathSegment(this.caseDoc);
        this.caseDoc.setPathInfo(this.parentPath, caseName);
        this.caseDoc = this.session.createDocument(this.caseDoc);
        ACP acp = this.caseDoc.getACP();
        ACL acl = acp.getOrCreateACL("mailboxes");
        for (Mailbox mailbox : this.mailboxes) {
            acl.add((Object)new ACE("mailbox_" + mailbox.getId(), "ReadWrite", true));
        }
        acp.addACL(acl);
        this.session.setACP(this.caseDoc.getRef(), acp, true);
    }

    public DocumentRef getEmptyCaseDocumentRef() {
        return this.caseDoc.getRef();
    }
}

