/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.service.GetMailboxesHeadersUnrestricted;
import org.nuxeo.cm.core.service.SearchMailboxesHeadersUnrestricted;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.mailbox.MailboxHeader;
import org.nuxeo.cm.service.MailboxCreator;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class MailboxManagementServiceImpl
implements MailboxManagementService {
    protected static final String QUERY_GET_ALL_MAILBOX = "GET_ALL_MAILBOX";
    protected static final String QUERY_GET_MAILBOX_FROM_ID = "GET_MAILBOX_FROM_ID";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(MailboxManagementServiceImpl.class);
    protected MailboxCreator personalMailboxCreator;
    protected EventProducer eventProducer;

    public Mailbox getMailbox(CoreSession session, String muid) {
        if (muid == null) {
            return null;
        }
        List<DocumentModel> res = this.executeQuery(session, QUERY_GET_MAILBOX_FROM_ID, muid);
        if (res == null || res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            log.warn((Object)String.format("Several mailboxes with id %s, returning first found", muid));
        }
        return (Mailbox)res.get(0).getAdapter(Mailbox.class);
    }

    public boolean hasMailbox(CoreSession session, String muid) {
        return this.getMailboxHeader(session, muid) != null;
    }

    public MailboxHeader getMailboxHeader(CoreSession session, String muid) {
        if (muid == null) {
            return null;
        }
        ArrayList<String> muids = new ArrayList<String>();
        muids.add(muid);
        List<MailboxHeader> mailboxesHeaders = this.getMailboxesHeaders(session, muids);
        if (mailboxesHeaders == null || mailboxesHeaders.isEmpty()) {
            return null;
        }
        return mailboxesHeaders.get(0);
    }

    public List<Mailbox> getMailboxes(CoreSession session, List<String> muids) {
        if (muids == null) {
            return null;
        }
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        for (String muid : muids) {
            if (muid == null) continue;
            List<DocumentModel> res = this.executeQuery(session, QUERY_GET_MAILBOX_FROM_ID, muid);
            if (res == null || res.isEmpty()) {
                log.warn((Object)String.format("No mailbox found with id '%s'", muid));
                continue;
            }
            if (res.size() > 1) {
                log.warn((Object)String.format("Several mailboxes with id '%s', returning first found", muid));
            }
            docs.add(res.get(0));
        }
        return MailboxConstants.getMailboxList(docs);
    }

    public List<MailboxHeader> getMailboxesHeaders(CoreSession session, List<String> muids) {
        GetMailboxesHeadersUnrestricted sessionSearch = new GetMailboxesHeadersUnrestricted(session, muids);
        try {
            sessionSearch.runUnrestricted();
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        return sessionSearch.getMailboxesHeaders();
    }

    public List<Mailbox> getUserMailboxes(CoreSession session, String user) {
        List<DocumentModel> res = this.executeQuery(session, QUERY_GET_ALL_MAILBOX, new Object[0]);
        ArrayList<Mailbox> mailboxes = new ArrayList<Mailbox>();
        if (res != null && !res.isEmpty()) {
            for (DocumentModel mbModel : res) {
                Mailbox mb = (Mailbox)mbModel.getAdapter(Mailbox.class);
                mailboxes.add(mb);
            }
        }
        return mailboxes;
    }

    public Mailbox getUserPersonalMailbox(CoreSession session, String user) {
        String mailboxId = this.getUserPersonalMailboxId(user);
        return this.getMailbox(session, mailboxId);
    }

    public List<Mailbox> createPersonalMailboxes(CoreSession session, String user) {
        if (this.personalMailboxCreator == null) {
            throw new CaseManagementRuntimeException("Cannot create personal mailbox: missing creator configuration");
        }
        String muid = this.getUserPersonalMailboxId(user);
        if (this.hasMailbox(session, muid)) {
            log.error((Object)String.format("Cannot create personal mailbox for user '%s': it already exists with id '%s'", user, muid));
            return Arrays.asList(this.getMailbox(session, muid));
        }
        try {
            return this.personalMailboxCreator.createMailboxes(session, user);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public Mailbox getUserPersonalMailboxForEmail(CoreSession session, String userEmail) {
        if (userEmail == null || StringUtils.isEmpty((String)userEmail)) {
            return null;
        }
        Directory dir = this.getUserDirectory();
        Session dirSession = null;
        List userIds = null;
        HashMap<String, String> filter = new HashMap<String, String>();
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            if (userManager != null) {
                filter.put(userManager.getUserEmailField(), userEmail);
                dirSession = dir.getSession();
                userIds = dirSession.getProjection(filter, dir.getIdField());
            } else {
                log.error((Object)"Could not resolve UserManager service");
            }
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException("Couldn't query user directory", (Throwable)e);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        finally {
            if (dirSession != null) {
                try {
                    dirSession.close();
                }
                catch (DirectoryException e) {}
            }
        }
        if (userIds != null && !userIds.isEmpty() && !StringUtils.isEmpty((String)((String)userIds.get(0)))) {
            return this.getUserPersonalMailbox(session, (String)userIds.get(0));
        }
        return null;
    }

    public List<MailboxHeader> searchMailboxes(CoreSession session, String pattern, String type2) {
        SearchMailboxesHeadersUnrestricted sessionSearch = new SearchMailboxesHeadersUnrestricted(session, pattern, type2);
        try {
            sessionSearch.runUnrestricted();
            return sessionSearch.getMailboxesHeaders();
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    public boolean hasUserPersonalMailbox(CoreSession session, String userId) {
        String muid = this.getUserPersonalMailboxId(userId);
        return this.hasMailbox(session, muid);
    }

    public String getUserPersonalMailboxId(String user) {
        DocumentModel userModel;
        UserManager userManager;
        try {
            userManager = (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        if (userManager == null) {
            throw new CaseManagementRuntimeException("User manager not found");
        }
        try {
            userModel = userManager.getUserModel(user);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        if (userModel == null) {
            log.debug((Object)String.format("No User by that name. Maybe a wrong id or virtual user", new Object[0]));
            return null;
        }
        return this.personalMailboxCreator.getPersonalMailboxId(userModel);
    }

    protected Directory getUserDirectory() {
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            String dirName = userManager == null ? "userDirectory" : userManager.getUserDirectoryName();
            return this.getDirService().getDirectory(dirName);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException("Error acccessing user directory", (Throwable)e);
        }
    }

    protected DirectoryService getDirService() {
        try {
            return (DirectoryService)Framework.getLocalService(DirectoryService.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException("Error while looking up directory service", (Throwable)e);
        }
    }

    protected List<DocumentModel> executeQuery(CoreSession session, String ppName, Object ... params) {
        List list;
        PageProviderService pps;
        try {
            pps = (PageProviderService)Framework.getService(PageProviderService.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        if (pps == null) {
            throw new CaseManagementRuntimeException("PageProviderService not found");
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)session);
        try {
            PageProvider pp = pps.getPageProvider(ppName, null, null, null, props, params);
            list = pp.getCurrentPage();
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        return list;
    }

    MailboxCreator getPersonalMailboxCreator() {
        return this.personalMailboxCreator;
    }

    void setPersonalMailboxCreator(MailboxCreator personalMailboxCreator) {
        this.personalMailboxCreator = personalMailboxCreator;
    }
}

