/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.List;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;

public class SetMailboxAclUnrestricted
extends UnrestrictedSessionRunner {
    protected final DocumentRef ref;
    protected final String permission;

    public SetMailboxAclUnrestricted(CoreSession session, DocumentRef ref, String permission) {
        super(session);
        this.ref = ref;
        if (permission == null) {
            throw new RuntimeException("Permission cannot be null");
        }
        this.permission = permission;
    }

    public SetMailboxAclUnrestricted(CoreSession session, DocumentRef ref) {
        this(session, ref, "ReadWrite");
    }

    public void run() throws ClientException {
        DocumentModel doc = this.session.getDocument(this.ref);
        Mailbox mb = (Mailbox)doc.getAdapter(Mailbox.class);
        List total = mb.getAllUsersAndGroups();
        if (total != null && !total.isEmpty()) {
            List groups;
            ACLImpl localACL = new ACLImpl("local");
            List users = mb.getAllUsers();
            if (users != null && !users.isEmpty()) {
                for (String user : users) {
                    ACE ace = new ACE(user, this.permission, true);
                    localACL.add((Object)ace);
                }
            }
            if ((groups = mb.getGroups()) != null && !groups.isEmpty()) {
                for (String group : groups) {
                    ACE ace = new ACE("cmfgroup_" + group, this.permission, true);
                    localACL.add((Object)ace);
                }
            }
            ACP acp = doc.getACP();
            acp.removeACL("local");
            acp.addACL((ACL)localACL);
            doc.setACP(acp, true);
        } else {
            ACP acp = doc.getACP();
            acp.removeACL("local");
            doc.setACP(acp, true);
        }
    }
}

