/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.importer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.service.importer.CaseManagementCaseItemDocumentFactory;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class CaseManagementImporter
extends AbstractImporterExecutor {
    private static final Log log = LogFactory.getLog(CaseManagementImporter.class);
    private String destionationMailboxPath;
    private String noImportingThreads;
    private String folderPath;
    private CaseManagementCaseItemDocumentFactory cmCaseItemDocFactory;

    public CaseManagementImporter(String destionationMailboxPath, String noImportingThreads, String folderPath, CaseManagementCaseItemDocumentFactory factory) {
        this.destionationMailboxPath = destionationMailboxPath;
        this.noImportingThreads = noImportingThreads;
        this.folderPath = folderPath;
        this.cmCaseItemDocFactory = factory;
    }

    protected Log getJavaLogger() {
        return log;
    }

    public void importDocuments() {
        FileSourceNode sourceNode = new FileSourceNode(this.folderPath);
        try {
            GenericMultiThreadedImporter importer = new GenericMultiThreadedImporter((SourceNode)sourceNode, this.destionationMailboxPath, Integer.valueOf(50), new Integer(this.noImportingThreads), this.getLogger());
            this.cmCaseItemDocFactory.setDestionationMailboxPath(this.destionationMailboxPath);
            importer.setFactory((ImporterDocumentModelFactory)this.cmCaseItemDocFactory);
            this.doRun((ImporterRunner)importer, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }
}

