/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;

public class XWPFTableRow {
    private CTRow ctRow;

    public XWPFTableRow(CTRow row) {
        this.ctRow = row;
    }

    public CTRow getCtRow() {
        return this.ctRow;
    }

    public XWPFTableCell createCell() {
        return new XWPFTableCell(this.ctRow.addNewTc());
    }

    public XWPFTableCell getCell(int pos) {
        if (pos >= 0 && pos < this.ctRow.sizeOfTcArray()) {
            return new XWPFTableCell(this.ctRow.getTcArray(pos));
        }
        return null;
    }

    public void setHeight(int height) {
        CTTrPr properties = this.getTrPr();
        CTHeight h = properties.getTrHeightArray(0) == null ? properties.addNewTrHeight() : properties.getTrHeightArray(0);
        h.setVal(new BigInteger("" + height));
    }

    public int getHeight() {
        CTTrPr properties = this.getTrPr();
        return properties.getTrHeightArray(0) == null ? 0 : properties.getTrHeightArray(0).getVal().intValue();
    }

    private CTTrPr getTrPr() {
        return this.ctRow.isSetTrPr() ? this.ctRow.getTrPr() : this.ctRow.addNewTrPr();
    }
}

