/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CSSSelector
implements ICSSWriteable {
    private final List<ICSSSelectorMember> m_aMembers = new ArrayList<ICSSSelectorMember>();

    public boolean hasMembers() {
        return !this.m_aMembers.isEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    public void addMember(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        if (iCSSSelectorMember == null) {
            throw new NullPointerException("member");
        }
        this.m_aMembers.add(iCSSSelectorMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(iCSSSelectorMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSSelectorMember getMemberAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMembers.size()) {
            return null;
        }
        return this.m_aMembers.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSelectorMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ICSSSelectorMember iCSSSelectorMember : this.m_aMembers) {
            stringBuilder.append(iCSSSelectorMember.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSSelector)) {
            return false;
        }
        CSSSelector cSSSelector = (CSSSelector)object;
        return ((Object)this.m_aMembers).equals(cSSSelector.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).toString();
    }
}

