/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.Arrays;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.Version;

class NuxeoCUDFPackage {
    public static final String CUDF_PACKAGE = "package: ";
    public static final String CUDF_VERSION = "version: ";
    public static final String CUDF_INSTALLED = "installed: ";
    public static final String CUDF_DEPENDS = "depends: ";
    public static final String CUDF_CONFLICTS = "conflicts: ";
    public static final String CUDF_PROVIDES = "provides: ";
    public static final String CUDF_REQUEST = "request: ";
    public static final String CUDF_INSTALL = "install: ";
    public static final String CUDF_REMOVE = "remove: ";
    public static final String CUDF_UPGRADE = "upgrade: ";
    private final String newLine = System.getProperty("line.separator");
    private DownloadablePackage pkg;
    private int cudfVersion;
    private String cudfName;
    private boolean installed;

    public NuxeoCUDFPackage(DownloadablePackage pkg) {
        this.pkg = pkg;
        this.cudfName = pkg.getName();
        if ("nuxeo-content-browser".equals(this.cudfName) && "cmf".equalsIgnoreCase(pkg.getVersion().classifier())) {
            this.cudfName = this.cudfName + "*" + pkg.getVersion().classifier();
        }
        this.setInstalled(pkg.getState() == PackageState.STARTED.getValue());
    }

    public String getCUDFName() {
        return this.cudfName;
    }

    public String getNuxeoName() {
        return this.pkg.getName();
    }

    public Version getNuxeoVersion() {
        return this.pkg.getVersion();
    }

    public void setCUDFVersion(int posInt) {
        this.cudfVersion = posInt;
    }

    public int getCUDFVersion() {
        return this.cudfVersion;
    }

    public String toString() {
        return "CUDF {" + this.cudfVersion + "}" + " Nuxeo {" + this.pkg.getVersion() + "} " + this.pkg.getClass();
    }

    public String getCUDFStanza() {
        StringBuffer sb = new StringBuffer();
        sb.append(CUDF_PACKAGE + this.cudfName + this.newLine);
        sb.append(CUDF_VERSION + this.cudfVersion + this.newLine);
        sb.append(CUDF_INSTALLED + this.installed + this.newLine);
        return sb.toString();
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public PackageDependency[] getDependencies() {
        return this.pkg.getDependencies();
    }

    public PackageDependency[] getConflicts() {
        PackageDependency[] conflicts = this.pkg.getConflicts();
        if ("nuxeo-content-browser*cmf".equals(this.cudfName)) {
            return this.addToConflicts(conflicts, "nuxeo-content-browser");
        }
        if ("nuxeo-content-browser".equals(this.cudfName)) {
            return this.addToConflicts(conflicts, "nuxeo-content-browser*cmf");
        }
        return conflicts;
    }

    private PackageDependency[] addToConflicts(PackageDependency[] conflicts, String dep) {
        PackageDependency[] withContentBrowser = conflicts != null && conflicts.length > 0 ? Arrays.copyOf(conflicts, conflicts.length + 1) : new PackageDependency[1];
        withContentBrowser[withContentBrowser.length - 1] = new PackageDependency(dep);
        return withContentBrowser;
    }

    public PackageDependency[] getProvides() {
        return this.pkg.getProvides();
    }

    public String getNuxeoId() {
        return this.pkg.getId();
    }

    public static String getCUDFName(PackageDependency dependency) {
        if ("nuxeo-content-browser".equals(dependency.getName()) && dependency.getVersionRange().toString().contains("cmf")) {
            return dependency.getName() + "*cmf";
        }
        return dependency.getName();
    }
}

