/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="metrics")
public class MetricsDescriptor
implements Serializable {
    private static final long serialVersionUID = 7833869486922092460L;
    @XNode(value="graphiteReporter")
    public GraphiteDescriptor graphiteReporter = new GraphiteDescriptor();
    @XNode(value="csvReporter")
    public CsvDescriptor csvReporter = new CsvDescriptor();
    @XNode(value="log4jInstrumentation")
    public Log4jInstrumentationDescriptor log4jInstrunmentation;
    @XNode(value="tomcatInstrumentation")
    public TomcatInstrumentationDescriptor tomcatInstrunmentation = new TomcatInstrumentationDescriptor();

    public MetricsDescriptor() {
        this.log4jInstrunmentation = new Log4jInstrumentationDescriptor();
    }

    @XObject(value="tomcatInstrumentation")
    public static class TomcatInstrumentationDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.tomcat.enabled";
        @XNode(value="@enabled")
        protected Boolean enabled;

        public boolean isEnabled() {
            if (this.enabled == null) {
                this.enabled = Boolean.valueOf(Framework.getProperty((String)ENABLED_PROPERTY, (String)"false"));
            }
            return this.enabled;
        }

        public String toString() {
            return String.format("tomcatInstrumentation %s", this.enabled != false ? "enabled" : "disabled");
        }
    }

    @XObject(value="log4jInstrumentation")
    public static class Log4jInstrumentationDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.log4j.enabled";
        @XNode(value="@enabled")
        protected Boolean enabled;

        public boolean isEnabled() {
            if (this.enabled == null) {
                this.enabled = Boolean.valueOf(Framework.getProperty((String)ENABLED_PROPERTY, (String)"false"));
            }
            return this.enabled;
        }

        public String toString() {
            return String.format("log4jInstrumentation %s", this.isEnabled() ? "enabled" : "disabled");
        }
    }

    @XObject(value="csvReporter")
    public static class CsvDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.csv.enabled";
        public static final String PERIOD_PROPERTY = "metrics.csv.period";
        public static final String OUTPUT_PROPERTY = "metrics.csv.output";
        @XNode(value="@output")
        public String outputPath;
        public File outputDir;
        @XNode(value="@periodInSecond")
        public Integer period = 10;
        @XNode(value="@enabled")
        public Boolean enabled;

        public boolean isEnabled() {
            if (this.enabled == null) {
                this.enabled = Boolean.valueOf(Framework.getProperty((String)ENABLED_PROPERTY, (String)"false"));
            }
            return this.enabled;
        }

        public int getPeriod() {
            if (this.period == null) {
                this.period = Integer.valueOf(Framework.getProperty((String)PERIOD_PROPERTY, (String)"10"));
            }
            return this.period;
        }

        public File getOutput() {
            if (this.outputDir == null) {
                if (this.outputPath == null) {
                    this.outputPath = Framework.getProperty((String)OUTPUT_PROPERTY, (String)Framework.getProperty((String)"nuxeo.log.dir"));
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
                Date today = Calendar.getInstance().getTime();
                this.outputDir = new File(this.outputPath, "metrics-" + df.format(today));
            }
            return this.outputDir;
        }

        public String toString() {
            return String.format("csvReporter %s, outputDir: %s, period: %d", this.isEnabled() ? "enabled" : "disabled", this.getOutput().toString(), this.getPeriod());
        }
    }

    @XObject(value="graphiteReporter")
    public static class GraphiteDescriptor {
        public static final String ENABLED_PROPERTY = "metrics.graphite.enabled";
        public static final String HOST_PROPERTY = "metrics.graphite.host";
        public static final String PORT_PROPERTY = "metrics.graphite.port";
        public static final String PERIOD_PROPERTY = "metrics.graphite.period";
        public static final String PREFIX_PROPERTY = "metrics.graphite.prefix";
        @XNode(value="@enabled")
        protected Boolean enabled;
        @XNode(value="@host")
        public String host;
        @XNode(value="@port")
        public Integer port;
        @XNode(value="@periodInSecond")
        public Integer period;
        @XNode(value="@prefix")
        public String prefix;

        public boolean isEnabled() {
            if (this.enabled == null) {
                this.enabled = Boolean.valueOf(Framework.getProperty((String)ENABLED_PROPERTY, (String)"false"));
            }
            return this.enabled;
        }

        public String getHost() {
            if (this.host == null) {
                this.host = Framework.getProperty((String)HOST_PROPERTY, (String)"0.0.0.0");
            }
            return this.host;
        }

        public int getPort() {
            if (this.port == null) {
                this.port = Integer.valueOf(Framework.getProperty((String)PORT_PROPERTY, (String)"2030"));
            }
            return this.port;
        }

        public int getPeriod() {
            if (this.period == null) {
                this.period = Integer.valueOf(Framework.getProperty((String)PERIOD_PROPERTY, (String)"10"));
            }
            return this.period;
        }

        public String getPrefix() {
            String hostname;
            if (this.prefix == null) {
                this.prefix = Framework.getProperty((String)PREFIX_PROPERTY, (String)"servers.${hostname}.nuxeo.");
            }
            try {
                hostname = InetAddress.getLocalHost().getHostName().split("\\.")[0];
            }
            catch (UnknownHostException e) {
                hostname = "unknown";
            }
            return this.prefix.replace("${hostname}", hostname);
        }

        public String toString() {
            return String.format("graphiteReporter %s prefix: %s, host: %s, port: %d, period: %d", this.isEnabled() ? "enabled" : "disabled", this.getPrefix(), this.getHost(), this.getPort(), this.getPeriod());
        }
    }
}

