/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.work.PrioritizedWork;
import org.nuxeo.ecm.core.work.api.Work;

public class FulltextUpdaterWork
extends PrioritizedWork {
    private static final Log log = LogFactory.getLog(FulltextUpdaterWork.class);
    protected static final String CATEGORY = "fulltextUpdater";
    protected static final String TITLE = "Fulltext Updater";
    protected boolean simpletext;
    protected String repositoryName;
    protected Collection<FulltextUpdaterInfo> infos;

    public FulltextUpdaterWork(boolean simpletext, String repositoryName, Collection<FulltextUpdaterInfo> infos) {
        super((simpletext ? "1" : "2") + "-" + System.currentTimeMillis());
        this.simpletext = simpletext;
        this.repositoryName = repositoryName;
        this.infos = infos;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getTitle() {
        return TITLE;
    }

    public Collection<DocumentLocation> getDocuments() {
        ArrayList<DocumentLocation> docs = new ArrayList<DocumentLocation>(this.infos.size());
        for (FulltextUpdaterInfo info : this.infos) {
            IdRef ref = new IdRef(info.jobId != null ? info.jobId : info.docId);
            DocumentLocationImpl doc = new DocumentLocationImpl(this.repositoryName, (DocumentRef)ref);
            docs.add((DocumentLocation)doc);
        }
        return docs;
    }

    public void work() throws Exception {
        if (this.infos.isEmpty()) {
            return;
        }
        this.initSession(this.repositoryName);
        if (this.session.getPrincipal() == null) {
            return;
        }
        boolean save = false;
        int n = 0;
        this.setStatus("Updating");
        for (FulltextUpdaterInfo info : this.infos) {
            Object docs;
            this.setProgress(new Work.Progress((long)(++n), (long)this.infos.size()));
            if (info.jobId != null) {
                String query = String.format("SELECT * FROM Document WHERE ecm:fulltextJobId = '%s' AND ecm:isProxy = 0", info.jobId);
                docs = this.session.query(query);
            } else {
                DocumentModel doc;
                IdRef ref = new IdRef(info.docId);
                if (!this.session.exists((DocumentRef)ref) || (doc = this.session.getDocument((DocumentRef)ref)).isProxy()) continue;
                docs = Collections.singleton(doc);
            }
            for (DocumentModel doc : docs) {
                try {
                    DocumentRef ref = doc.getRef();
                    if (info.jobId != null) {
                        this.session.setDocumentSystemProp(ref, "fulltextJobId", null);
                    }
                    this.session.setDocumentSystemProp(ref, this.getFulltextPropertyName(info.indexName), (Serializable)((Object)info.text));
                    save = true;
                }
                catch (DocumentException e) {
                    log.error((Object)("Could not set fulltext on: " + doc.getId()), (Throwable)e);
                }
            }
        }
        if (save) {
            this.setStatus("Saving");
            this.session.save();
        }
        this.setStatus(null);
    }

    protected String getFulltextPropertyName(String indexName) {
        String name;
        String string = name = this.simpletext ? "simpleText" : "binaryText";
        if (!"default".equals(indexName)) {
            name = name + '_' + indexName;
        }
        return name;
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        this.infos.clear();
        this.infos = null;
    }

    public static class FulltextUpdaterInfo {
        String docId;
        String jobId;
        String indexName;
        String text;

        public String toString() {
            return this.getClass().getSimpleName() + '(' + (this.jobId != null ? "job=" + this.jobId : "doc=" + this.docId) + ", index=" + this.indexName + ")";
        }
    }
}

