/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;

public class CaseLinkRemovedListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext eventCtx = event.getContext();
        Serializable envelopeObject = eventCtx.getProperty("eventContextCaseLink");
        if (!(envelopeObject instanceof CaseLink)) {
            return;
        }
        CaseLink link = (CaseLink)envelopeObject;
        CoreSession session = eventCtx.getCoreSession();
        DocumentModel mailbox = session.getParentDocument(link.getDocument().getRef());
        String caseId = link.getCase(session).getDocument().getId();
        String query = String.format("Select * from CaseLink where ecm:parentId = '%s' and cslk:caseDocumentId = '%s'", mailbox.getId(), caseId);
        DocumentModelList links = session.query(query);
        if (links.size() == 1) {
            ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
            DocumentModel kaseDocument = session.getDocument((DocumentRef)new IdRef(caseId));
            docs.add(kaseDocument);
            List items = ((Case)kaseDocument.getAdapter(Case.class)).getCaseItems(session);
            for (CaseItem item : items) {
                docs.add(item.getDocument());
            }
            for (DocumentModel doc : docs) {
                ACP acp = doc.getACP();
                ACL mailboxACL = acp.getOrCreateACL("mailboxes");
                ArrayList<ACE> newACES = new ArrayList<ACE>();
                for (ACE ace : mailboxACL.getACEs()) {
                    if (ace.getUsername().equals("mailbox_" + ((Mailbox)mailbox.getAdapter(Mailbox.class)).getId())) continue;
                    newACES.add(ace);
                }
                acp.removeACL("mailboxes");
                mailboxACL.setACEs(newACES.toArray(new ACE[0]));
                acp.addACL(mailboxACL);
                session.setACP(doc.getRef(), acp, true);
            }
        }
    }
}

