/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.io.Serializable;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class CreateMailboxRouteRootUnrestricted
extends UnrestrictedSessionRunner {
    protected final DocumentModel doc;

    public CreateMailboxRouteRootUnrestricted(CoreSession session, DocumentModel doc) {
        super(session);
        this.doc = doc;
    }

    public void run() throws ClientException {
        Mailbox mb = (Mailbox)this.doc.getAdapter(Mailbox.class);
        String routeRootName = CreateMailboxRouteRootUnrestricted.getRouteRootNamePrefix() + mb.getTitle();
        String routeFolderId = IdUtils.generateId((String)routeRootName, (String)"-", (boolean)true, (int)24);
        DocumentModel routeRoot = this.session.createDocumentModel(this.doc.getPathAsString(), routeFolderId, "RouteRoot");
        routeRoot.setPropertyValue("dc:title", (Serializable)((Object)routeRootName));
        routeRoot = this.session.createDocument(routeRoot);
        ACP acp = routeRoot.getACP();
        ACL acl = acp.getOrCreateACL("local");
        acl.add((Object)new ACE("mailbox_" + mb.getId(), "Everything", true));
        acp.addACL(acl);
        routeRoot.setACP(acp, true);
        this.session.saveDocument(routeRoot);
    }

    public static String getRouteRootNamePrefix() {
        return "Routes - ";
    }
}

