/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.caselink.CaseLinkRequestImpl;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.core.caselink.CreateCaseLink;
import org.nuxeo.cm.core.caselink.CreateDraftCaseLinkUnrestricted;
import org.nuxeo.cm.core.caselink.UpdateCaseLinkUnrestricted;
import org.nuxeo.cm.core.service.CreateCaseItemUnrestricted;
import org.nuxeo.cm.core.service.CreateEmptyCaseUnrestricted;
import org.nuxeo.cm.core.service.GetMailboxesUnrestricted;
import org.nuxeo.cm.core.service.MailboxManagementServiceImpl;
import org.nuxeo.cm.distribution.DistributionInfo;
import org.nuxeo.cm.event.CaseManagementEventConstants;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxHeader;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.cm.service.CaseManagementPersister;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.runtime.api.Framework;

public class CaseDistributionServiceImpl
implements CaseDistributionService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseDistributionServiceImpl.class);
    protected EventProducer eventProducer;
    protected Map<String, Serializable> context;
    protected CaseManagementPersister persister;
    protected PathSegmentService pathSegmentService;

    public void setPersister(CaseManagementPersister persister) {
        this.persister = persister;
    }

    public void setPathSegmentService(PathSegmentService pathSegmentService) {
        this.pathSegmentService = pathSegmentService;
    }

    public CaseLink sendCase(CoreSession session, CaseLink postRequest, boolean isInitial) {
        try {
            SendPostUnrestricted sendPostUnrestricted = new SendPostUnrestricted(session, postRequest, isInitial);
            sendPostUnrestricted.runUnrestricted();
            return sendPostUnrestricted.getPost();
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    public CaseLink sendCase(CoreSession session, CaseLink postRequest, boolean isInitial, boolean actionable) {
        try {
            SendPostUnrestricted sendPostUnrestricted = new SendPostUnrestricted(session, postRequest, isInitial, actionable);
            sendPostUnrestricted.runUnrestricted();
            return sendPostUnrestricted.getPost();
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    public CaseLink sendCase(CoreSession session, String origin, Case kase, DistributionInfo initialDistribution) {
        Map recipients = initialDistribution.getAllParticipants();
        try {
            CaseLinkRequestImpl postRequest = new CaseLinkRequestImpl(origin, Calendar.getInstance(), kase.getDocument().getTitle(), null, kase, recipients, null);
            return this.sendCase(session, (CaseLink)postRequest, kase.isDraft());
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    protected DocumentModelList executeQueryModel(CoreSession session, String queryModel) {
        return this.executeQueryModel(session, queryModel, new Object[0]);
    }

    protected DocumentModelList executeQueryModel(CoreSession session, String queryModel, Object[] params) {
        QueryModelService qmService = null;
        try {
            qmService = (QueryModelService)Framework.getService(QueryModelService.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        if (qmService == null) {
            throw new CaseManagementRuntimeException("Query Manager not found");
        }
        QueryModelDescriptor qmd = qmService.getQueryModelDescriptor(queryModel);
        QueryModel qm = new QueryModel(qmd);
        DocumentModelList list = null;
        try {
            list = qm.getDocuments(session, params);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        return list;
    }

    protected List<CaseLink> getPosts(CoreSession coreSession, long offset, long limit, String query) {
        DocumentModelList result;
        ArrayList<CaseLink> posts = new ArrayList<CaseLink>();
        try {
            result = coreSession.query(query, null, limit, offset, false);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        for (DocumentModel documentModel : result) {
            posts.add((CaseLink)documentModel.getAdapter(CaseLink.class));
        }
        return posts;
    }

    public List<CaseLink> getReceivedCaseLinks(CoreSession coreSession, Mailbox mailbox, long offset, long limit) {
        if (mailbox == null) {
            return null;
        }
        String query = String.format("SELECT * FROM Document WHERE ecm:parentId ='%s' and %s=0", mailbox.getDocument().getId(), "cslk:isSent");
        return this.getPosts(coreSession, offset, limit, query);
    }

    public List<CaseLink> getCaseLinks(CoreSession session, Mailbox mailbox, Case kase) {
        String query = String.format("SELECT * FROM Document WHERE ecm:mixinType = 'CaseLink' and cslk:caseDocumentId = '%s'", kase.getDocument().getId());
        if (mailbox != null) {
            query = query + String.format(" and ecm:parentId = '%s'", mailbox.getDocument().getId());
        }
        return this.getPosts(session, 0L, 0L, query);
    }

    public List<CaseLink> getSentCaseLinks(CoreSession coreSession, Mailbox mailbox, long offset, long limit) {
        if (mailbox == null) {
            return null;
        }
        String query = String.format("SELECT * FROM Document WHERE ecm:parentId ='%s' and %s=1", mailbox.getDocument().getId(), "cslk:isSent");
        return this.getPosts(coreSession, offset, limit, query);
    }

    public List<CaseLink> getDraftCaseLinks(CoreSession coreSession, Mailbox mailbox, long offset, long limit) {
        if (mailbox == null) {
            return null;
        }
        String query = String.format("SELECT * FROM Document WHERE ecm:parentId ='%s' and %s=1", mailbox.getDocument().getId(), "cslk:draft");
        return this.getPosts(coreSession, offset, limit, query);
    }

    public CaseItem addCaseItemToCase(CoreSession session, Case kase, DocumentModel emailDoc) {
        try {
            String parentPath = this.persister.getParentDocumentPathForCaseItem(session, kase);
            CreateCaseItemUnrestricted mailCreator = new CreateCaseItemUnrestricted(session, emailDoc, kase.getDocument().getACP(), parentPath);
            mailCreator.runUnrestricted();
            DocumentModel mail = session.getDocument(mailCreator.getDocRef());
            CaseItem newCaseItem = (CaseItem)mail.getAdapter(CaseItem.class);
            kase.addCaseItem(newCaseItem, session);
            newCaseItem.save(session);
            kase.save(session);
            return newCaseItem;
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    public Case createCase(CoreSession session, DocumentModel emailDoc, List<Mailbox> mailboxes) {
        try {
            String emailTitle = emailDoc.getTitle();
            String caseId = this.pathSegmentService.generatePathSegment(emailDoc);
            Case kase = this.createEmptyCase(session, emailTitle, caseId, mailboxes);
            this.addCaseItemToCase(session, kase, emailDoc);
            return kase;
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    public Case createCase(CoreSession session, DocumentModel emailDoc) {
        return this.createCase(session, emailDoc, new ArrayList<Mailbox>());
    }

    public Case createEmptyCase(CoreSession session, String title, String id, Mailbox mailbox) {
        return this.createEmptyCase(session, title, id, Collections.singletonList(mailbox));
    }

    public Case createEmptyCase(CoreSession session, String title, String id, List<Mailbox> mailboxes) {
        return this.createEmptyCase(session, title, id, this.getTypeService().getCaseType(), mailboxes);
    }

    public Case createEmptyCase(CoreSession session, String title, String id, String type2, List<Mailbox> mailboxes) {
        return this.createEmptyCase(session, title, id, type2, null, mailboxes);
    }

    public Case createEmptyCase(CoreSession session, String title, String id, String type2, Date date, List<Mailbox> mailboxes) {
        String parentPath = this.getParentDocumentPathForCase(session);
        try {
            DocumentModel kase = session.createDocumentModel(parentPath, id, type2);
            kase.setPropertyValue("dc:title", (Serializable)((Object)title));
            kase.putContextData("initialLifecycleState", null);
            return this.createEmptyCase(session, kase, date, mailboxes);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public CaseManagementDocumentTypeService getTypeService() {
        try {
            return (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Case createEmptyCase(CoreSession session, DocumentModel caseDoc, Mailbox mailbox) {
        return this.createEmptyCase(session, caseDoc, Collections.singletonList(mailbox));
    }

    public Case createEmptyCase(CoreSession session, DocumentModel caseDoc, Date date, List<Mailbox> mailboxes) {
        String parentPath = this.getParentDocumentPathForCase(session, date);
        CreateEmptyCaseUnrestricted emptyCaseCreator = new CreateEmptyCaseUnrestricted(session, caseDoc, parentPath, mailboxes);
        try {
            emptyCaseCreator.runUnrestricted();
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        DocumentRef caseDocRef = emptyCaseCreator.getEmptyCaseDocumentRef();
        try {
            caseDoc = session.getDocument(caseDocRef);
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        return (Case)caseDoc.getAdapter(Case.class);
    }

    public Case createEmptyCase(CoreSession session, DocumentModel caseDoc, List<Mailbox> mailboxes) {
        return this.createEmptyCase(session, caseDoc, null, mailboxes);
    }

    public CaseLink createDraftCaseLink(CoreSession session, Mailbox mailbox, Case envelope) {
        try {
            HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
            eventProperties.put("eventContextCase", (Serializable)envelope);
            eventProperties.put("category", (Serializable)((Object)"DISTRIBUTION"));
            this.fireEvent(session, envelope, eventProperties, CaseManagementEventConstants.EventNames.beforeDraftCreated.name());
            CreateDraftCaseLinkUnrestricted runner = new CreateDraftCaseLinkUnrestricted(session.getRepositoryName(), (String)((Object)envelope.getDocument().getPropertyValue("dc:title")), envelope, mailbox);
            runner.runUnrestricted();
            DocumentModel draftDoc = session.getDocument((DocumentRef)new IdRef(runner.getCreatedPostDocRef()));
            CaseLink draft = (CaseLink)draftDoc.getAdapter(CaseLink.class);
            eventProperties.put("eventContextDraft", (Serializable)draft);
            this.fireEvent(session, envelope, eventProperties, CaseManagementEventConstants.EventNames.afterDraftCreated.name());
            return draft;
        }
        catch (ClientException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    public CaseLink getDraftCaseLink(CoreSession coreSession, Mailbox mailbox, String envelopeId) {
        if (mailbox == null) {
            return null;
        }
        String query = String.format("SELECT * FROM Document WHERE ecm:parentId ='%s' AND %s='%s' and %s=1", mailbox.getDocument().getId(), "cslk:caseDocumentId", envelopeId, "cslk:draft");
        List<CaseLink> result = this.getPosts(coreSession, 0L, 0L, query);
        int size = result.size();
        if (size > 1) {
            log.error((Object)("More than one draft for envelope '" + envelopeId + "'."));
            return null;
        }
        if (size == 0) {
            return null;
        }
        return result.get(0);
    }

    protected void fireEvent(CoreSession coreSession, Case envelope, Map<String, Serializable> eventProperties, String caseEventName, String caseItemEventName) {
        try {
            DocumentEventContext envContext = new DocumentEventContext(coreSession, coreSession.getPrincipal(), envelope.getDocument());
            envContext.setProperties(eventProperties);
            this.getEventProducer().fireEvent(envContext.newEvent(caseEventName));
            List items = envelope.getCaseItems(coreSession);
            if (caseItemEventName != null) {
                for (CaseItem item : items) {
                    DocumentModel doc = item.getDocument();
                    DocumentEventContext docContext = new DocumentEventContext(coreSession, coreSession.getPrincipal(), doc);
                    docContext.setProperties(eventProperties);
                    this.getEventProducer().fireEvent(docContext.newEvent(caseItemEventName));
                }
            }
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    protected void fireEvent(CoreSession coreSession, Case envelope, Map<String, Serializable> eventProperties, String caseEventName) {
        this.fireEvent(coreSession, envelope, eventProperties, caseEventName, null);
    }

    public void removeCaseLink(final CaseLink link, CoreSession session) {
        final DocumentRef ref = link.getDocument().getRef();
        try {
            final Principal principal = session.getPrincipal();
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    try {
                        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                        eventProperties.put("eventContextCaseLink", link);
                        eventProperties.put("category", "DISTRIBUTION");
                        DocumentEventContext envContext = new DocumentEventContext(this.session, principal, link.getDocument());
                        envContext.setProperties(eventProperties);
                        CaseDistributionServiceImpl.this.getEventProducer().fireEvent(envContext.newEvent(CaseManagementEventConstants.EventNames.beforeCaseLinkRemovedEvent.name()));
                        this.session.removeDocument(ref);
                        envContext.getProperties().remove("eventContextCaseLink");
                        CaseDistributionServiceImpl.this.getEventProducer().fireEvent(envContext.newEvent(CaseManagementEventConstants.EventNames.afterCaseLinkRemovedEvent.name()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public void notify(CoreSession session, String name, DocumentModel document, Map<String, Serializable> eventProperties) {
        DocumentEventContext envContext = new DocumentEventContext(session, session.getPrincipal(), document);
        envContext.setProperties(eventProperties);
        try {
            this.getEventProducer().fireEvent(envContext.newEvent(name));
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected EventProducer getEventProducer() throws Exception {
        if (this.eventProducer == null) {
            this.eventProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        return this.eventProducer;
    }

    public DocumentModel getParentDocumentForCase(CoreSession session) {
        return this.persister.getParentDocumentForCase(session);
    }

    public DocumentModel getParentDocumentForCase(CoreSession session, Date date) {
        return this.persister.getParentDocumentForCase(session, date);
    }

    public String getParentDocumentPathForCaseItem(CoreSession session, Case kase) {
        return this.persister.getParentDocumentPathForCaseItem(session, kase);
    }

    public String getParentDocumentPathForCase(CoreSession session) {
        return this.persister.getParentDocumentPathForCase(session);
    }

    public String getParentDocumentPathForCase(CoreSession session, Date date) {
        return this.persister.getParentDocumentPathForCase(session, date);
    }

    public Case createCaseFromExistingCaseItem(CaseItem item, CoreSession session) {
        return this.persister.createCaseFromExistingCaseItem(item, session);
    }

    public class SendPostUnrestricted
    extends UnrestrictedSessionRunner {
        protected final CaseLink postRequest;
        protected final boolean isInitial;
        protected EventProducer eventProducer;
        protected CaseLink post;
        protected boolean isActionable;

        public SendPostUnrestricted(CoreSession session, CaseLink postRequest, boolean isInitial) {
            super(session);
            this.isActionable = false;
            this.postRequest = postRequest;
            this.isInitial = isInitial;
        }

        public SendPostUnrestricted(CoreSession session, CaseLink postRequest, boolean isInitial, boolean isActionable) {
            super(session);
            this.isActionable = false;
            this.postRequest = postRequest;
            this.isInitial = isInitial;
            this.isActionable = isActionable;
        }

        public void run() throws CaseManagementException {
            try {
                String senderMailboxId = this.postRequest.getSender();
                GetMailboxesUnrestricted getMailboxesUnrestricted = new GetMailboxesUnrestricted(this.session, senderMailboxId);
                getMailboxesUnrestricted.runUnrestricted();
                List<Mailbox> senderMailboxes = getMailboxesUnrestricted.getMailboxes();
                Mailbox senderMailbox = null;
                if (senderMailboxes != null && !senderMailboxes.isEmpty()) {
                    senderMailbox = senderMailboxes.get(0);
                }
                String subject = this.postRequest.getSubject();
                String comment = this.postRequest.getComment();
                Case kase = this.postRequest.getCase(this.session);
                HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
                Map externalRecipients = this.postRequest.getInitialExternalParticipants();
                Map internalRecipientIds = this.postRequest.getInitialInternalParticipants();
                ArrayList<String> mailboxTitles = new ArrayList<String>();
                for (String type2 : internalRecipientIds.keySet()) {
                    mailboxTitles.clear();
                    List<MailboxHeader> mailboxesHeaders = new MailboxManagementServiceImpl().getMailboxesHeaders(this.session, (List)internalRecipientIds.get(type2));
                    if (senderMailboxes != null) {
                        for (MailboxHeader mailboxHeader : mailboxesHeaders) {
                            mailboxTitles.add(mailboxHeader.getTitle());
                        }
                    }
                    eventProperties.put("eventContextParticipants_type_" + type2, (Serializable)((Object)StringUtils.join(mailboxTitles, (String)", ")));
                }
                eventProperties.put("eventContextSender", (Serializable)senderMailbox);
                eventProperties.put("eventContextSubject", (Serializable)((Object)subject));
                eventProperties.put("comment", (Serializable)((Object)comment));
                eventProperties.put("eventContextCase", (Serializable)kase);
                eventProperties.put("eventContextParticipants", (Serializable)((Object)internalRecipientIds));
                eventProperties.put("eventContextExternalParticipants", (Serializable)((Object)externalRecipients));
                eventProperties.put("category", (Serializable)((Object)"DISTRIBUTION"));
                eventProperties.put("eventContextIsInitial", Boolean.valueOf(this.isInitial));
                CaseDistributionServiceImpl.this.fireEvent(this.session, kase, eventProperties, CaseManagementEventConstants.EventNames.beforeCaseSentEvent.name(), CaseManagementEventConstants.EventNames.beforeCaseItemSentEvent.name());
                if (this.isInitial) {
                    if (senderMailbox != null) {
                        CaseLink draft = CaseDistributionServiceImpl.this.getDraftCaseLink(this.session, senderMailbox, kase.getDocument().getId());
                        if (draft == null) {
                            throw new CaseManagementException("No draft for an initial send.");
                        }
                        UpdateCaseLinkUnrestricted createPostUnrestricted = new UpdateCaseLinkUnrestricted(this.session, subject, comment, kase, senderMailbox, senderMailbox.getId(), internalRecipientIds, externalRecipients, true, this.isInitial, draft);
                        createPostUnrestricted.run();
                        this.post = createPostUnrestricted.getUpdatedPost();
                    }
                } else if (senderMailbox != null) {
                    CreateCaseLink createPost = new CreateCaseLink(null, this.session, subject, comment, kase, senderMailbox, senderMailbox.getId(), internalRecipientIds, externalRecipients, true, this.isInitial);
                    createPost.create();
                    this.post = createPost.getCreatedPost();
                }
                for (String type2 : internalRecipientIds.keySet()) {
                    for (String recipient : (List)internalRecipientIds.get(type2)) {
                        CreateCaseLink createMessage;
                        if (this.isActionable) {
                            createMessage = new CreateCaseLink(this.postRequest, this.session, subject, comment, kase, senderMailbox, recipient, internalRecipientIds, externalRecipients, false, this.isInitial);
                            createMessage.create();
                            continue;
                        }
                        createMessage = new CreateCaseLink(this.post, this.session, subject, comment, kase, senderMailbox, recipient, internalRecipientIds, externalRecipients, false, this.isInitial);
                        createMessage.create();
                    }
                }
                CaseDistributionServiceImpl.this.fireEvent(this.session, kase, eventProperties, CaseManagementEventConstants.EventNames.afterCaseSentEvent.name(), CaseManagementEventConstants.EventNames.afterCaseItemSentEvent.name());
            }
            catch (ClientException e) {
                throw new CaseManagementException((Throwable)e);
            }
        }

        public CaseLink getPost() {
            return this.post;
        }
    }
}

