/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.ArrayList;
import java.util.Collection;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class CreateCaseItemUnrestricted
extends UnrestrictedSessionRunner {
    protected final DocumentModel doc;
    protected final ACP caseACP;
    protected DocumentRef ref;
    protected final String parentPath;

    public CreateCaseItemUnrestricted(CoreSession session, DocumentModel doc, ACP caseACP, String parentPath) throws ClientException {
        super(session);
        if (doc.getId() != null) {
            doc.detach(true);
        }
        this.doc = doc;
        this.caseACP = caseACP;
        this.parentPath = parentPath;
    }

    public void run() throws ClientException {
        DocumentModel newDoc = this.session.createDocumentModel(this.parentPath, this.doc.getName(), this.doc.getType());
        newDoc.copyContent(this.doc);
        newDoc = this.session.createDocument(newDoc);
        ACP acp = newDoc.getACP();
        ACL acl = acp.getOrCreateACL("mailboxes");
        ACL aces = this.caseACP.getACL("mailboxes");
        acl.addAll((Collection)(aces == null ? new ArrayList() : aces));
        acp.addACL(acl);
        this.session.setACP(newDoc.getRef(), acp, true);
        this.ref = newDoc.getRef();
    }

    public DocumentRef getDocRef() {
        return this.ref;
    }
}

