/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.service.synchronization.DefaultPersonalMailboxTitleGenerator;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.cm.service.MailboxCreator;
import org.nuxeo.cm.service.MailboxTitleGenerator;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class DefaultMailboxCreator
implements MailboxCreator {
    protected static final String CM_DEFAULT_MAILBOX_CREATOR_SKIP = "cm.defaultMailboxCreator.skip";
    private static final Log log = LogFactory.getLog(DefaultMailboxCreator.class);

    protected String getMailboxType() throws ClientException {
        CaseManagementDocumentTypeService correspDocumentTypeService;
        try {
            correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return correspDocumentTypeService.getMailboxType();
    }

    public String getPersonalMailboxId(DocumentModel userModel) {
        String userId = userModel.getId();
        return IdUtils.generateId((String)("user:" + userId), (String)"-", (boolean)true, (int)24);
    }

    public MailboxTitleGenerator getTitleGenerator() {
        return new DefaultPersonalMailboxTitleGenerator();
    }

    public List<Mailbox> createMailboxes(CoreSession session, String user) throws CaseManagementException {
        String skipCreation = Framework.getProperty((String)CM_DEFAULT_MAILBOX_CREATOR_SKIP);
        if (skipCreation != null && skipCreation.equals(Boolean.TRUE.toString())) {
            return Collections.emptyList();
        }
        try {
            UserManager userManager = (UserManager)Framework.getService(UserManager.class);
            if (userManager == null) {
                throw new CaseManagementException("User manager not found");
            }
            DocumentModel userModel = userManager.getUserModel(user);
            if (userModel == null) {
                log.debug((Object)String.format("No User by that name. Maybe a wrong id or virtual user", new Object[0]));
                return Collections.emptyList();
            }
            DocumentModel mailboxModel = session.createDocumentModel(this.getMailboxType());
            Mailbox mailbox = (Mailbox)mailboxModel.getAdapter(Mailbox.class);
            String id = this.getPersonalMailboxId(userModel);
            mailbox.setId(id);
            MailboxTitleGenerator gen = this.getTitleGenerator();
            if (gen == null) {
                gen = new DefaultPersonalMailboxTitleGenerator();
            }
            mailbox.setTitle(gen.getMailboxTitle(userModel));
            mailbox.setOwner(user);
            mailbox.setType(MailboxConstants.type.personal.name());
            ArrayList<String> list = new ArrayList<String>();
            list.add("cellule_courrier");
            mailbox.setProfiles(list);
            mailboxModel.setPathInfo(this.getMailboxParentPath(session), this.getMailboxPathSegment(userModel, mailboxModel));
            this.beforeMailboxCreation(session, mailbox, userModel);
            mailboxModel = session.createDocument(mailboxModel);
            session.save();
            mailbox = (Mailbox)mailboxModel.getAdapter(Mailbox.class);
            return Collections.singletonList(mailbox);
        }
        catch (Exception e) {
            throw new CaseManagementException("Error during mailboxes creation", (Throwable)e);
        }
    }

    protected void beforeMailboxCreation(CoreSession session, Mailbox mailbox, DocumentModel userEntry) {
    }

    protected String getMailboxParentPath(CoreSession session) throws ClientException {
        return DefaultMailboxCreator.getNewMailboxParentPath(session);
    }

    protected String getMailboxPathSegment(DocumentModel dirEntry, DocumentModel mailboxModel) throws ClientException {
        return DefaultMailboxCreator.getNewMailboxPathSegment(mailboxModel);
    }

    public static String getNewMailboxParentPath(CoreSession session) throws ClientException {
        DocumentModelList res = session.query(String.format("SELECT * from %s", "MailboxRoot"));
        if (res == null || res.isEmpty()) {
            throw new CaseManagementException("Cannot find any mailbox folder");
        }
        return ((DocumentModel)res.get(0)).getPathAsString();
    }

    public static String getNewMailboxPathSegment(DocumentModel mailboxModel) throws ClientException {
        String baseid = mailboxModel.getTitle();
        if (baseid == null) {
            throw new ClientException("No base id for mailbox path creation");
        }
        return IdUtils.generateId((String)baseid, (String)"-", (boolean)true, (int)24);
    }
}

