/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.caseimporter;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.core.service.caseimporter.sourcenodes.CaseItemSourceNode;
import org.nuxeo.cm.core.service.caseimporter.sourcenodes.CaseSourceNode;
import org.nuxeo.cm.core.service.importer.CaseManagementCaseItemDocumentFactory;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public class CaseManagementCaseImporterDocumentsFactory
extends CaseManagementCaseItemDocumentFactory {
    private static final Log log = LogFactory.getLog(CaseManagementCaseImporterDocumentsFactory.class);
    private CaseManagementDocumentTypeService cmTypeService;

    @Override
    public DocumentModel createLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws Exception {
        if (node instanceof CaseItemSourceNode) {
            DocumentModel caseItemDoc = this.defaultCreateCaseItemDocType(session, null, node);
            Case kase = (Case)parent.getAdapter(Case.class);
            CaseItem caseItem = this.getCaseDistributionService().addCaseItemToCase(session, kase, caseItemDoc);
            return caseItem.getDocument();
        }
        return null;
    }

    @Override
    public DocumentModel createFolderishNode(CoreSession session, DocumentModel parent, SourceNode node) throws Exception {
        if (node instanceof CaseSourceNode) {
            return this.defaultCreateCaseDoc(session, parent.getPathAsString(), node, "Case");
        }
        return this.getCaseDistributionService().getParentDocumentForCase(session);
    }

    protected DocumentModel defaultCreateCaseItemDocType(CoreSession session, String parentPath, SourceNode node) throws Exception {
        return this.defaultCreateNodeDoc(session, parentPath, node, this.getCaseManagementDocumentTypeService().getCaseItemType());
    }

    protected DocumentModel defaultCreateCaseDoc(CoreSession session, String parentPath, SourceNode node, String docType) throws Exception {
        CaseSourceNode caseNode = (CaseSourceNode)node;
        ExportedDocument xdoc = this.exportDocumentFromNode(caseNode);
        DocumentModel doc = session.createDocumentModel(parentPath, "Case", this.getCaseManagementDocumentTypeService().getCaseType());
        doc = session.createDocument(doc);
        DocumentModelWriter writer = new DocumentModelWriter(session, doc.getPathAsString(), 1);
        try {
            writer.write(xdoc);
        }
        catch (Exception e) {
            log.error((Object)"Failed to read ExportedDocument", (Throwable)e);
        }
        doc = session.getDocument(doc.getRef());
        this.notifyCaseImported(session, doc, node);
        return doc;
    }

    protected ExportedDocument exportDocumentFromNode(CaseSourceNode node) throws ClientException {
        ExportedDocumentImpl xdoc = new ExportedDocumentImpl();
        xdoc.setDocument(node.getCaseDocument());
        String envelopeId = new SimpleDateFormat("yyyy-MM-dd_HHmmss").format(new Date());
        xdoc.setId("ImportedCase_" + envelopeId);
        return xdoc;
    }

    private CaseManagementDocumentTypeService getCaseManagementDocumentTypeService() throws Exception {
        if (this.cmTypeService == null) {
            this.cmTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        return this.cmTypeService;
    }
}

