/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.caseimporter.sourcenodes;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.nuxeo.cm.core.service.caseimporter.sourcenodes.CaseItemSourceNode;
import org.nuxeo.cm.distribution.DistributionInfo;
import org.nuxeo.cm.service.caseimporter.AbstractXMLCaseReader;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class CaseSourceNode
implements SourceNode {
    private Element caseDocument;
    private AbstractXMLCaseReader xmlReader;
    private String rootPath;

    CaseSourceNode(Element caseDocument, AbstractXMLCaseReader xmlReader, String rootPath) {
        this.caseDocument = caseDocument;
        this.xmlReader = xmlReader;
        this.rootPath = rootPath;
    }

    public BlobHolder getBlobHolder() {
        return null;
    }

    public List<SourceNode> getChildren() {
        ArrayList<SourceNode> itemNodes = new ArrayList<SourceNode>();
        List docs = this.xmlReader.loadCaseItems(this.caseDocument);
        for (Element el : docs) {
            itemNodes.add((SourceNode)new CaseItemSourceNode(el, this.xmlReader, this.rootPath));
        }
        return itemNodes;
    }

    public String getName() {
        return null;
    }

    public String getSourcePath() {
        return null;
    }

    public boolean isFolderish() {
        return this.getChildren().size() > 0;
    }

    public Element getCaseElement() {
        return this.caseDocument;
    }

    public Document getCaseDocument() {
        return this.xmlReader.extractEntireCase(this.caseDocument);
    }

    public DistributionInfo getDistributionInfo() {
        return this.xmlReader.getDistributionInfo(this.caseDocument);
    }
}

