/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.usermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.nuxeo.cm.core.usermanager.GetMailboxInformationUnrestricted;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfoCallbackHandler;
import org.nuxeo.ecm.platform.computedgroups.AbstractGroupComputer;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class CaseManagementGroupComputer
extends AbstractGroupComputer {
    public static final ThreadLocal<Boolean> disableRetrieveMailboxes = new ThreadLocal();
    protected static MailboxManagementService cfms;

    public List<String> getAllGroupIds() throws Exception {
        return Collections.emptyList();
    }

    public List<String> searchGroups(Map<String, Serializable> filter, Set<String> fulltext) throws Exception {
        return Collections.emptyList();
    }

    public List<String> getGroupMembers(String groupName) throws Exception {
        GetMailboxInformationUnrestricted runner = new GetMailboxInformationUnrestricted(this.getRepoName(), this.getMailboxManager(), groupName);
        runner.runUnrestricted();
        return runner.getMailboxMembers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupsForUser(NuxeoPrincipalImpl pal) throws Exception {
        if (pal != null && !Boolean.TRUE.equals(disableRetrieveMailboxes.get())) {
            ArrayList<String> arrayList;
            LoginContext loginContext;
            CoreSession session;
            block11: {
                disableRetrieveMailboxes.set(Boolean.TRUE);
                session = null;
                loginContext = null;
                boolean isNewTransactionStarted = false;
                try {
                    List<String> vgroups;
                    String userMailboxId;
                    String username = pal.getName();
                    loginContext = this.loginOnContext(username);
                    session = this.openCoreSession(username);
                    if (!TransactionHelper.isTransactionActive()) {
                        isNewTransactionStarted = TransactionHelper.startTransaction();
                    }
                    List mailboxes = this.getMailboxManager().getUserMailboxes(session, pal.getName());
                    ArrayList<String> res = new ArrayList<String>();
                    if (mailboxes != null) {
                        for (Mailbox folder : mailboxes) {
                            res.add("mailbox_" + folder.getId());
                        }
                    }
                    if ((userMailboxId = "mailbox_" + this.getMailboxManager().getUserPersonalMailboxId(username)) != null && !res.contains(userMailboxId)) {
                        res.add(userMailboxId);
                    }
                    if ((vgroups = this.getVirtualGroupsForMailboxHierarchy((NuxeoPrincipal)pal)) != null) {
                        res.addAll(vgroups);
                    }
                    arrayList = res;
                    if (!isNewTransactionStarted) break block11;
                }
                catch (Throwable throwable) {
                    if (isNewTransactionStarted) {
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                    this.closeCoreSession(session);
                    disableRetrieveMailboxes.remove();
                    if (loginContext != null) {
                        loginContext.logout();
                    }
                    throw throwable;
                }
                TransactionHelper.commitOrRollbackTransaction();
            }
            this.closeCoreSession(session);
            disableRetrieveMailboxes.remove();
            if (loginContext != null) {
                loginContext.logout();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected List<String> getVirtualGroupsForMailboxHierarchy(NuxeoPrincipal pal) throws ClientException {
        UserManager um = this.getUM();
        ArrayList<String> res = new ArrayList<String>();
        HashSet<String> checkedGroups = new HashSet<String>();
        ArrayList groupsToProcess = new ArrayList();
        groupsToProcess.addAll(pal.getGroups());
        while (!groupsToProcess.isEmpty()) {
            String groupName = (String)groupsToProcess.remove(0);
            if (checkedGroups.contains(groupName)) continue;
            checkedGroups.add(groupName);
            NuxeoGroup nxGroup = null;
            if (um != null) {
                nxGroup = um.getGroup(groupName);
            }
            if (nxGroup == null) continue;
            groupsToProcess.addAll(nxGroup.getMemberGroups());
            res.add("cmfgroup_" + nxGroup.getName());
        }
        return res;
    }

    public List<String> getParentsGroupNames(String groupName) throws Exception {
        GetMailboxInformationUnrestricted runner = new GetMailboxInformationUnrestricted(this.getRepoName(), this.getMailboxManager(), groupName);
        runner.runUnrestricted();
        return runner.getMailboxParentNames();
    }

    public List<String> getSubGroupsNames(String groupName) throws Exception {
        GetMailboxInformationUnrestricted runner = new GetMailboxInformationUnrestricted(this.getRepoName(), this.getMailboxManager(), groupName);
        runner.runUnrestricted();
        return runner.getMailboxSubFolderNames();
    }

    public boolean hasGroup(String name) throws Exception {
        return false;
    }

    protected MailboxManagementService getMailboxManager() {
        if (cfms == null) {
            cfms = (MailboxManagementService)Framework.getLocalService(MailboxManagementService.class);
        }
        return cfms;
    }

    protected LoginContext loginOnContext(String username) throws LoginException {
        if (!Framework.isTestModeSet()) {
            UserIdentificationInfo userIdent = new UserIdentificationInfo(username, "");
            userIdent.setLoginPluginName("Trusting_LM");
            UserIdentificationInfoCallbackHandler handler = new UserIdentificationInfoCallbackHandler(userIdent);
            LoginContext loginContext = new LoginContext("nuxeo-ecm-web", (CallbackHandler)handler);
            loginContext.login();
            return loginContext;
        }
        return null;
    }

    protected CoreSession openCoreSession(String username) {
        try {
            String repositoryName = this.getRepoName();
            Repository repository = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepository(repositoryName);
            if (repository == null) {
                throw new ClientException("Cannot get repository: " + repositoryName);
            }
            HashMap<String, String> context = new HashMap<String, String>();
            if (Framework.isTestModeSet()) {
                context.put("username", username);
            }
            return repository.open(context);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected void closeCoreSession(CoreSession session) {
        if (session != null) {
            Repository.close((CoreSession)session);
        }
    }

    protected String getRepoName() {
        RepositoryManager mgr = null;
        try {
            mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e.getMessage(), (Throwable)e);
        }
        if (mgr == null) {
            throw new CaseManagementRuntimeException("Unable to find Repository Manager.");
        }
        Repository repo = mgr.getDefaultRepository();
        return repo.getName();
    }
}

