/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.usermanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public class GetMailboxInformationUnrestricted
extends UnrestrictedSessionRunner {
    protected final MailboxManagementService service;
    protected final String mailboxId;
    protected List<String> members;
    protected List<String> parents;
    protected List<String> children;

    public GetMailboxInformationUnrestricted(String repoName, MailboxManagementService service, String mailboxId) {
        super(repoName);
        this.service = service;
        this.mailboxId = mailboxId;
    }

    public void run() throws ClientException {
        this.members = null;
        this.parents = null;
        this.children = null;
        Mailbox mailbox = this.service.getMailbox(this.session, this.mailboxId);
        if (mailbox != null) {
            this.members = mailbox.getAllUsers();
            String parentId = mailbox.getParentId(this.session);
            if (parentId != null) {
                this.parents = new ArrayList<String>();
                this.parents.add(parentId);
            }
            this.children = mailbox.getChildrenIds(this.session);
        }
    }

    public List<String> getMailboxMembers() {
        if (this.members == null) {
            this.members = Collections.emptyList();
        }
        return this.members;
    }

    public List<String> getMailboxParentNames() {
        if (this.parents == null) {
            this.parents = Collections.emptyList();
        }
        return this.parents;
    }

    public List<String> getMailboxSubFolderNames() {
        if (this.children == null) {
            this.children = Collections.emptyList();
        }
        return this.children;
    }
}

