/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;

public class AddThumbnailUnrestricted
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(AddThumbnailUnrestricted.class);
    protected DocumentModel doc;

    public AddThumbnailUnrestricted(CoreSession coreSession, DocumentModel doc, BlobHolder blobHolder) {
        super(coreSession);
        this.doc = doc;
    }

    public void run() throws ClientException {
        try {
            ThumbnailAdapter thumbnailAdapter = (ThumbnailAdapter)this.doc.getAdapter(ThumbnailAdapter.class);
            if (thumbnailAdapter != null) {
                Blob thumbnailBlob = thumbnailAdapter.computeThumbnail(this.session);
                if (thumbnailBlob != null) {
                    if (!this.doc.hasFacet("Thumbnail")) {
                        this.doc.addFacet("Thumbnail");
                    }
                    if (!this.doc.isProxy() && !this.doc.isVersion()) {
                        this.doc.setPropertyValue("thumb:thumbnail", (Serializable)thumbnailBlob);
                        this.saveDocument();
                    }
                } else if (this.doc.hasFacet("Thumbnail") && !this.doc.isProxy() && !this.doc.isVersion()) {
                    this.doc.setPropertyValue("thumb:thumbnail", null);
                    this.doc.removeFacet("Thumbnail");
                    this.saveDocument();
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error while adding thumbnail", (Throwable)e);
        }
    }

    protected void saveDocument() throws ClientException {
        this.doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        this.session.saveDocument(this.doc);
        this.session.save();
    }
}

