/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.json;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayoutImpl;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewStateImpl;
import org.nuxeo.ecm.platform.contentview.json.DocumentModelToJSON;
import org.nuxeo.ecm.platform.forms.layout.io.Base64;

public class JSONContentViewState {
    private static final Log log = LogFactory.getLog(JSONContentViewState.class);
    public static final String ENCODED_VALUES_ENCODING = "UTF-8";

    public static String toJSON(ContentViewState state, boolean encode) throws ClientException, UnsupportedEncodingException {
        if (state == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoding content view state: " + state));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.element("contentViewName", (Object)state.getContentViewName());
        jsonObject.element("pageSize", (Object)state.getPageSize());
        jsonObject.element("currentPage", (Object)state.getCurrentPage());
        JSONArray jsonQueryParams = new JSONArray();
        Object[] queryParams = state.getQueryParameters();
        if (queryParams != null) {
            jsonQueryParams.addAll(Arrays.asList(queryParams));
        }
        jsonObject.element("queryParameters", (Collection)jsonQueryParams);
        jsonObject.element("searchDocument", (Map)JSONContentViewState.getDocumentModelToJSON(state.getSearchDocumentModel()));
        JSONArray jsonSortInfos = new JSONArray();
        List<SortInfo> sortInfos = state.getSortInfos();
        if (sortInfos != null) {
            for (SortInfo sortInfo : sortInfos) {
                jsonSortInfos.add((Object)JSONContentViewState.getSortInfoToJSON(sortInfo));
            }
        }
        jsonObject.element("sortInfos", (Collection)jsonSortInfos);
        jsonObject.element("resultLayout", (Map)JSONContentViewState.getContentViewLayoutToJSON(state.getResultLayout()));
        List<String> resultColumns = state.getResultColumns();
        if (resultColumns != null) {
            jsonObject.element("resultColumns", resultColumns);
        }
        String jsonString = jsonObject.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoded content view state: " + jsonString));
        }
        if (encode) {
            String encodedValues = Base64.encodeBytes((byte[])jsonString.getBytes(), (int)10);
            jsonString = URLEncoder.encode(encodedValues, ENCODED_VALUES_ENCODING);
        }
        return jsonString;
    }

    public static ContentViewState fromJSON(String json, boolean decode) throws UnsupportedEncodingException, ClientException {
        if (json == null || json.trim().length() == 0) {
            return null;
        }
        if (decode) {
            String decodedValues = URLDecoder.decode(json, ENCODED_VALUES_ENCODING);
            json = new String(Base64.decode((String)decodedValues));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoding content view state: " + json));
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        ContentViewStateImpl state = new ContentViewStateImpl();
        state.setContentViewName(jsonObject.getString("contentViewName"));
        state.setPageSize(new Long(jsonObject.optLong("pageSize", -1L)));
        state.setCurrentPage(new Long(jsonObject.optLong("currentPage", -1L)));
        JSONArray jsonQueryParams = jsonObject.getJSONArray("queryParameters");
        ArrayList queryParams = new ArrayList();
        if (jsonQueryParams != null) {
            for (Object item : jsonQueryParams) {
                queryParams.add(item);
            }
        }
        state.setQueryParameters(queryParams.toArray(new Object[0]));
        JSONObject jsonDoc = jsonObject.getJSONObject("searchDocument");
        DocumentModel searchDoc = JSONContentViewState.getDocumentModelFromJSON(jsonDoc);
        state.setSearchDocumentModel(searchDoc);
        JSONArray jsonSortInfos = jsonObject.getJSONArray("sortInfos");
        ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        if (jsonSortInfos != null) {
            for (Object item : jsonSortInfos) {
                sortInfos.add(JSONContentViewState.getSortInfoFromJSON((JSONObject)item));
            }
        }
        state.setSortInfos(sortInfos);
        state.setResultLayout(JSONContentViewState.getContentViewLayoutFromJSON(jsonObject.getJSONObject("resultLayout")));
        JSONArray jsonResultColumns = jsonObject.optJSONArray("resultColumns");
        if (jsonResultColumns != null) {
            ArrayList<String> resultColumns = new ArrayList<String>();
            resultColumns.addAll((Collection<String>)jsonResultColumns);
            state.setResultColumns(resultColumns);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Decoded content view state: " + state));
        }
        return state;
    }

    protected static JSONObject getSortInfoToJSON(SortInfo sortInfo) {
        JSONObject res = new JSONObject();
        res.element("sortColumn", (Object)sortInfo.getSortColumn());
        res.element("sortAscending", sortInfo.getSortAscending());
        return res;
    }

    protected static SortInfo getSortInfoFromJSON(JSONObject jsonSortInfo) {
        String sortColumn = jsonSortInfo.getString("sortColumn");
        boolean sortAscending = jsonSortInfo.getBoolean("sortAscending");
        return new SortInfo(sortColumn, sortAscending);
    }

    protected static JSONObject getDocumentModelToJSON(DocumentModel doc) throws ClientException {
        if (doc == null) {
            return null;
        }
        JSONObject res = new JSONObject();
        res.element("type", (Object)doc.getType());
        JSONObject props = new DocumentModelToJSON().run(doc);
        res.element("properties", (Map)props);
        return res;
    }

    protected static DocumentModel getDocumentModelFromJSON(JSONObject jsonDoc) throws ClientException {
        if (jsonDoc == null || jsonDoc.isNullObject()) {
            return null;
        }
        String docType = jsonDoc.getString("type");
        DocumentModelImpl doc = DocumentModelFactory.createDocumentModel((String)docType);
        JSONObject props = jsonDoc.getJSONObject("properties");
        Iterator keys = props.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            doc.setPropertyValue(key, JSONContentViewState.getDocumentPropertyValue(props.get(key)));
        }
        return doc;
    }

    protected static JSONObject getContentViewLayoutToJSON(ContentViewLayout cvLayout) {
        if (cvLayout == null) {
            return null;
        }
        JSONObject res = new JSONObject();
        res.element("name", (Object)cvLayout.getName());
        res.element("title", (Object)cvLayout.getTitle());
        res.element("translateTitle", cvLayout.getTranslateTitle());
        res.element("iconPath", (Object)cvLayout.getIconPath());
        res.element("showCSVExport", cvLayout.getShowCSVExport());
        return res;
    }

    protected static ContentViewLayout getContentViewLayoutFromJSON(JSONObject jsonCvLayout) {
        if (jsonCvLayout == null || jsonCvLayout.isNullObject()) {
            return null;
        }
        String name = jsonCvLayout.optString("name", null);
        String title = jsonCvLayout.optString("title", null);
        boolean translateTitle = jsonCvLayout.optBoolean("translateTitle");
        String iconPath = jsonCvLayout.optString("iconPath", null);
        boolean showCSVExport = jsonCvLayout.optBoolean("showCSVExport");
        return new ContentViewLayoutImpl(name, title, translateTitle, iconPath, showCSVExport);
    }

    protected static Serializable getDocumentPropertyValue(Object o) throws JSONException {
        if (o instanceof String) {
            Calendar calendar = null;
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
                Date date = df.parse((String)o);
                calendar = Calendar.getInstance();
                calendar.setTime(date);
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (calendar != null) {
                return calendar;
            }
            return (Serializable)o;
        }
        if (o instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)o;
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(JSONContentViewState.getDocumentPropertyValue(jsonArray.get(i)));
            }
            return list;
        }
        if (o instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)o;
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                map.put(key, JSONContentViewState.getDocumentPropertyValue(jsonObject.get(key)));
            }
            return map;
        }
        return (Serializable)o;
    }
}

