/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.base;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TxHelper {
    private static final Log log = LogFactory.getLog(TxHelper.class);
    private static final String UT_NAME = "UserTransaction";
    private static final String UT_NAME_ALT = "java:comp/UserTransaction";
    private static final String TM_NAME = "TransactionManager";
    private static final String TM_NAME_ALT = "java:/TransactionManager";
    protected UserTransaction tx;
    protected boolean disabled = false;

    public void beginNewTransaction() {
        this.beginNewTransaction(null);
    }

    public void beginNewTransaction(Integer transactionTimeout) {
        if (this.disabled) {
            return;
        }
        if (this.tx != null) {
            throw new UnsupportedOperationException("There is already an uncommited transaction running");
        }
        this.tx = this.createUT(transactionTimeout);
        if (this.tx == null) {
            log.debug((Object)"No TransactionManager");
            this.disabled = true;
            return;
        }
        try {
            if (this.tx.getStatus() == 3) {
                log.error((Object)"Transaction is already commited, try to begin anyway");
            }
            this.tx.begin();
        }
        catch (Exception e) {
            log.error((Object)"Unable to start transaction", (Throwable)e);
        }
    }

    public void grabCurrentTransaction(Integer transactionTimeout) {
        this.tx = this.createUT(transactionTimeout);
    }

    protected UserTransaction createUT(Integer transactionTimeout) {
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (Exception e) {
            this.disabled = true;
            return null;
        }
        UserTransaction ut = null;
        try {
            ut = (UserTransaction)context.lookup(UT_NAME);
        }
        catch (NamingException ne) {
            try {
                ut = (UserTransaction)context.lookup(UT_NAME_ALT);
            }
            catch (NamingException ne2) {
                this.disabled = true;
            }
        }
        if (transactionTimeout != null && ut != null) {
            try {
                ut.setTransactionTimeout(transactionTimeout.intValue());
            }
            catch (SystemException e) {
                log.error((Object)("Error while setting transaction timeout to " + transactionTimeout), (Throwable)e);
            }
        }
        return ut;
    }

    protected Transaction createTxFromTM() {
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (Exception e) {
            this.disabled = true;
            return null;
        }
        TransactionManager tm = null;
        try {
            tm = (TransactionManager)context.lookup(TM_NAME);
        }
        catch (NamingException ne) {
            try {
                tm = (TransactionManager)context.lookup(TM_NAME_ALT);
            }
            catch (NamingException ne2) {
                // empty catch block
            }
        }
        if (tm == null) {
            this.disabled = true;
            return null;
        }
        try {
            return tm.getTransaction();
        }
        catch (SystemException e) {
            this.disabled = true;
            return null;
        }
    }

    protected boolean isUTTransactionActive() {
        try {
            return this.tx.getStatus() == 0;
        }
        catch (SystemException e) {
            log.error((Object)"Error while getting tx status", (Throwable)e);
            return false;
        }
    }

    private boolean isUTTransactionMarkedRollback() {
        try {
            int status = this.tx.getStatus();
            return status == 1 || status == 4;
        }
        catch (SystemException e) {
            log.error((Object)"Error while getting tx status", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        if (this.disabled || this.tx == null) {
            return;
        }
        try {
            if (!this.isUTTransactionMarkedRollback()) {
                this.tx.setRollbackOnly();
            }
            this.commitOrRollbackTransaction();
        }
        catch (Exception e) {
            log.error((Object)"Error while marking tx for rollback", (Throwable)e);
        }
        finally {
            this.tx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitOrRollbackTransaction() {
        if (this.disabled || this.tx == null) {
            return;
        }
        try {
            if (this.isUTTransactionActive()) {
                try {
                    this.tx.commit();
                }
                catch (Exception e) {
                    log.error((Object)"Error during commit", (Throwable)e);
                }
            } else {
                try {
                    log.debug((Object)"Rolling back transaction");
                    this.tx.rollback();
                }
                catch (Exception e) {
                    log.debug((Object)"Error during rollback", (Throwable)e);
                }
            }
        }
        finally {
            this.tx = null;
        }
    }
}

