/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl.visit;

import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CSSViewportRule;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.IHasCSSDeclarations;
import com.phloc.css.decl.visit.CSSVisitorForUrl;
import com.phloc.css.decl.visit.ICSSUrlVisitor;
import com.phloc.css.decl.visit.ICSSVisitor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSVisitor {
    private CSSVisitor() {
    }

    public static void visitAllDeclarations(@Nonnull IHasCSSDeclarations iHasCSSDeclarations, @Nonnull ICSSVisitor iCSSVisitor) {
        for (CSSDeclaration cSSDeclaration : iHasCSSDeclarations.getAllDeclarations()) {
            iCSSVisitor.onDeclaration(cSSDeclaration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitStyleRule(@Nonnull CSSStyleRule cSSStyleRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginStyleRule(cSSStyleRule);
        try {
            for (CSSSelector cSSSelector : cSSStyleRule.getAllSelectors()) {
                iCSSVisitor.onStyleRuleSelector(cSSSelector);
            }
            CSSVisitor.visitAllDeclarations(cSSStyleRule, iCSSVisitor);
        }
        finally {
            iCSSVisitor.onEndStyleRule(cSSStyleRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitPageRule(@Nonnull CSSPageRule cSSPageRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginPageRule(cSSPageRule);
        try {
            CSSVisitor.visitAllDeclarations(cSSPageRule, iCSSVisitor);
        }
        finally {
            iCSSVisitor.onEndPageRule(cSSPageRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitFontFaceRule(@Nonnull CSSFontFaceRule cSSFontFaceRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginFontFaceRule(cSSFontFaceRule);
        try {
            CSSVisitor.visitAllDeclarations(cSSFontFaceRule, iCSSVisitor);
        }
        finally {
            iCSSVisitor.onEndFontFaceRule(cSSFontFaceRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitMediaRule(@Nonnull CSSMediaRule cSSMediaRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginMediaRule(cSSMediaRule);
        try {
            for (ICSSTopLevelRule iCSSTopLevelRule : cSSMediaRule.getAllRules()) {
                CSSVisitor.visitTopLevelRule(iCSSTopLevelRule, iCSSVisitor);
            }
        }
        finally {
            iCSSVisitor.onEndMediaRule(cSSMediaRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitKeyframesRule(@Nonnull CSSKeyframesRule cSSKeyframesRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginKeyframesRule(cSSKeyframesRule);
        try {
            for (CSSKeyframesBlock cSSKeyframesBlock : cSSKeyframesRule.getAllBlocks()) {
                iCSSVisitor.onBeginKeyframesBlock(cSSKeyframesBlock);
                try {
                    CSSVisitor.visitAllDeclarations(cSSKeyframesBlock, iCSSVisitor);
                }
                finally {
                    iCSSVisitor.onEndKeyframesBlock(cSSKeyframesBlock);
                }
            }
        }
        finally {
            iCSSVisitor.onEndKeyframesRule(cSSKeyframesRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitViewportRule(@Nonnull CSSViewportRule cSSViewportRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onBeginViewportRule(cSSViewportRule);
        try {
            CSSVisitor.visitAllDeclarations(cSSViewportRule, iCSSVisitor);
        }
        finally {
            iCSSVisitor.onEndViewportRule(cSSViewportRule);
        }
    }

    public static void visitNamespaceRule(@Nonnull CSSNamespaceRule cSSNamespaceRule, @Nonnull ICSSVisitor iCSSVisitor) {
        iCSSVisitor.onNamespace(cSSNamespaceRule);
    }

    public static void visitTopLevelRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule, @Nonnull ICSSVisitor iCSSVisitor) {
        if (iCSSTopLevelRule instanceof CSSStyleRule) {
            CSSVisitor.visitStyleRule((CSSStyleRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSPageRule) {
            CSSVisitor.visitPageRule((CSSPageRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSFontFaceRule) {
            CSSVisitor.visitFontFaceRule((CSSFontFaceRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSMediaRule) {
            CSSVisitor.visitMediaRule((CSSMediaRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSKeyframesRule) {
            CSSVisitor.visitKeyframesRule((CSSKeyframesRule)iCSSTopLevelRule, iCSSVisitor);
        } else if (iCSSTopLevelRule instanceof CSSViewportRule) {
            CSSVisitor.visitViewportRule((CSSViewportRule)iCSSTopLevelRule, iCSSVisitor);
        } else {
            throw new IllegalStateException("Top level rule " + iCSSTopLevelRule + " is unsupported!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitCSS(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull ICSSVisitor iCSSVisitor) {
        if (cascadingStyleSheet == null) {
            throw new NullPointerException("CSS");
        }
        if (iCSSVisitor == null) {
            throw new NullPointerException("visitor");
        }
        iCSSVisitor.begin();
        try {
            for (CSSImportRule iCSSWriteable : cascadingStyleSheet.getAllImportRules()) {
                iCSSVisitor.onImport(iCSSWriteable);
            }
            for (CSSNamespaceRule cSSNamespaceRule : cascadingStyleSheet.getAllNamespaceRules()) {
                iCSSVisitor.onNamespace(cSSNamespaceRule);
            }
            for (ICSSTopLevelRule iCSSTopLevelRule : cascadingStyleSheet.getAllRules()) {
                CSSVisitor.visitTopLevelRule(iCSSTopLevelRule, iCSSVisitor);
            }
        }
        finally {
            iCSSVisitor.end();
        }
    }

    public static void visitCSSUrl(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        CSSVisitor.visitCSS(cascadingStyleSheet, new CSSVisitorForUrl(iCSSUrlVisitor));
    }

    public static void visitAllDeclarationUrls(@Nonnull IHasCSSDeclarations iHasCSSDeclarations, @Nonnull ICSSUrlVisitor iCSSUrlVisitor) {
        CSSVisitor.visitAllDeclarations(iHasCSSDeclarations, new CSSVisitorForUrl(iCSSUrlVisitor));
    }
}

