/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.graphite.GraphiteReporter;
import com.yammer.metrics.log4j.InstrumentedAppender;
import com.yammer.metrics.reporting.CsvReporter;
import com.yammer.metrics.util.JmxGauge;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsDescriptor;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class MetricsServiceImpl
extends DefaultComponent
implements MetricsService {
    private static final Log log = LogFactory.getLog(MetricsServiceImpl.class);
    private final Counter instanceUp = Metrics.defaultRegistry().newCounter(MetricsServiceImpl.class, "instance-up");
    public static final String CONFIGURATION_EP = "configuration";
    public static MetricsDescriptor config;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIGURATION_EP.equals(extensionPoint) && contribution instanceof MetricsDescriptor) {
            log.debug((Object)"Registering metrics contribution");
            config = (MetricsDescriptor)contribution;
        } else {
            log.warn((Object)("Unknown EP " + extensionPoint));
        }
    }

    public void activate(ComponentContext context) {
        log.debug((Object)"Activate component.");
    }

    public void deactivate(ComponentContext context) {
        this.instanceUp.dec();
        log.debug((Object)"Deactivate component.");
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        if (config == null) {
            config = new MetricsDescriptor();
        }
        log.info((Object)"Setting up metrics configuration");
        if (MetricsServiceImpl.config.graphiteReporter.isEnabled()) {
            log.info((Object)MetricsServiceImpl.config.graphiteReporter);
            GraphiteReporter.enable((long)MetricsServiceImpl.config.graphiteReporter.getPeriod(), (TimeUnit)TimeUnit.SECONDS, (String)MetricsServiceImpl.config.graphiteReporter.getHost(), (int)MetricsServiceImpl.config.graphiteReporter.getPort(), (String)MetricsServiceImpl.config.graphiteReporter.getPrefix());
        }
        if (MetricsServiceImpl.config.csvReporter.isEnabled()) {
            log.info((Object)MetricsServiceImpl.config.csvReporter);
            File outputDir = MetricsServiceImpl.config.csvReporter.getOutput();
            if (outputDir.getParentFile().exists() && outputDir.getParentFile().isDirectory()) {
                outputDir.mkdir();
                CsvReporter.enable((File)outputDir, (long)MetricsServiceImpl.config.csvReporter.period.intValue(), (TimeUnit)TimeUnit.SECONDS);
            } else {
                MetricsServiceImpl.config.csvReporter.enabled = false;
                log.error((Object)("Invalid output directory, disabling: " + MetricsServiceImpl.config.csvReporter));
            }
        }
        if (MetricsServiceImpl.config.log4jInstrunmentation.isEnabled()) {
            log.info((Object)MetricsServiceImpl.config.log4jInstrunmentation);
            LogManager.getRootLogger().addAppender((Appender)new InstrumentedAppender());
        }
        this.instanceUp.inc();
        if (MetricsServiceImpl.config.tomcatInstrunmentation.isEnabled()) {
            log.info((Object)MetricsServiceImpl.config.tomcatInstrunmentation);
            String commonDs = "jdbc/nuxeo";
            Metrics.defaultRegistry().newGauge(this.getClass(), "jdbc-numActive", (Gauge)new JmxGauge("Catalina:type=DataSource,class=javax.sql.DataSource,name=\"" + commonDs + "\"", "numActive"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "jdbc-numIdle", (Gauge)new JmxGauge("Catalina:type=DataSource,class=javax.sql.DataSource,name=\"" + commonDs + "\"", "numIdle"));
            String connector = String.format("http-%s-%s", Framework.getProperty((String)"nuxeo.bind.address", (String)"0.0.0.0"), Framework.getProperty((String)"nuxeo.bind.port", (String)"8080"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "tomcat-currentThreadCount", (Gauge)new JmxGauge("Catalina:type=ThreadPool,name=" + connector, "currentThreadCount"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "tomcat-currentThreadsBusy", (Gauge)new JmxGauge("Catalina:type=ThreadPool,name=" + connector, "currentThreadsBusy"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "tomcat-errorCount", (Gauge)new JmxGauge("Catalina:type=GlobalRequestProcessor,name=" + connector, "errorCount"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "tomcat-errorCount", (Gauge)new JmxGauge("Catalina:type=GlobalRequestProcessor,name=" + connector, "errorCount"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "tomcat-requestCount", (Gauge)new JmxGauge("Catalina:type=GlobalRequestProcessor,name=" + connector, "requestCount"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "tomcat-processingTime", (Gauge)new JmxGauge("Catalina:type=GlobalRequestProcessor,name=" + connector, "processingTime"));
            Metrics.defaultRegistry().newGauge(this.getClass(), "tomcat-activeSessions", (Gauge)new JmxGauge("Catalina:type=Manager,path=/nuxeo,host=localhost", "activeSessions"));
        }
    }
}

