/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;

public interface GraphNode {
    public static final String MERGE_ONE = "one";
    public static final String MERGE_ALL = "all";
    public static final String PROP_NODE_ID = "rnode:nodeId";
    public static final String PROP_TITLE = "dc:title";
    public static final String PROP_START = "rnode:start";
    public static final String PROP_STOP = "rnode:stop";
    public static final String PROP_MERGE = "rnode:merge";
    public static final String PROP_COUNT = "rnode:count";
    public static final String PROP_CANCELED = "rnode:canceled";
    public static final String PROP_INPUT_CHAIN = "rnode:inputChain";
    public static final String PROP_OUTPUT_CHAIN = "rnode:outputChain";
    public static final String PROP_HAS_TASK = "rnode:hasTask";
    public static final String PROP_VARIABLES_FACET = "rnode:variablesFacet";
    public static final String PROP_TRANSITIONS = "rnode:transitions";
    public static final String PROP_TRANS_NAME = "name";
    public static final String PROP_TRANS_TARGET = "targetId";
    public static final String PROP_TRANS_CONDITION = "condition";
    public static final String PROP_TRANS_RESULT = "result";
    public static final String PROP_TRANS_CHAIN = "chain";
    public static final String PROP_TRANS_LABEL = "label";
    public static final String PROP_TASK_ASSIGNEES = "rnode:taskAssignees";
    public static final String PROP_TASK_ASSIGNEES_VAR = "rnode:taskAssigneesExpr";
    public static final String PROP_TASK_ASSIGNEES_PERMISSION = "rnode:taskAssigneesPermission";
    public static final String PROP_TASK_DUE_DATE = "rnode:taskDueDate";
    public static final String PROP_TASK_DIRECTIVE = "rnode:taskDirective";
    public static final String PROP_TASK_LAYOUT = "rnode:taskLayout";
    public static final String PROP_TASK_BUTTONS = "rnode:taskButtons";
    public static final String PROP_BTN_NAME = "name";
    public static final String PROP_BTN_LABEL = "label";
    public static final String PROP_BTN_FILTER = "filter";
    public static final String PROP_NODE_X_COORDINATE = "rnode:taskX";
    public static final String PROP_NODE_Y_COORDINATE = "rnode:taskY";
    public static final String PROP_NODE_BUTTON = "rnode:button";
    public static final String PROP_NODE_START_DATE = "rnode:startDate";
    public static final String PROP_NODE_END_DATE = "rnode:endDate";
    public static final String PROP_NODE_LAST_ACTOR = "rnode:lastActor";
    public static final String PROP_TASK_DOC_TYPE = "rnode:taskDocType";
    public static final String PROP_TASK_NOTIFICATION_TEMPLATE = "rnode:taskNotificationTemplate";
    public static final String PROP_TASK_DUE_DATE_EXPR = "rnode:taskDueDateExpr";

    public String getId();

    public State getState();

    public void setState(State var1);

    public boolean isStart();

    public boolean isStop();

    public boolean isMerge();

    public boolean canMerge();

    public void setCanceled();

    public long getCanceledCount();

    public void cancelTasks();

    public String getInputChain();

    public String getOutputChain();

    public boolean hasTask();

    public List<String> getTaskAssignees();

    public Date getTaskDueDate();

    public String getTaskDirective();

    public String getTaskAssigneesPermission();

    public String getTaskLayout();

    public String getTaskDocType();

    public String getTaskNotificationTemplate();

    public void starting();

    public void ending();

    public void executeChain(String var1) throws DocumentRouteException;

    public void initAddInputTransition(Transition var1);

    public List<Transition> getInputTransitions();

    public List<Transition> getOutputTransitions();

    public String getTaskDueDateExpr();

    public void executeTransitionChain(Transition var1) throws DocumentRouteException;

    public List<Transition> evaluateTransitions() throws DocumentRouteException;

    public void setAllVariables(Map<String, Object> var1);

    public List<Button> getTaskButtons();

    public DocumentModel getDocument();

    public Map<String, Serializable> getVariables();

    public void setButton(String var1);

    public void setLastActor(String var1);

    public List<String> evaluateTaskAssignees() throws DocumentRouteException;

    public Date computeTaskDueDate() throws DocumentRouteException;

    public Map<String, Serializable> getWorkflowContextualInfo(boolean var1);

    public static class Button
    implements Comparable<Button> {
        public GraphNode source;
        public String name;
        public String label;
        public String filter;
        public MapProperty prop;

        public Button(GraphNode source, Property p) throws ClientException {
            this.source = source;
            this.prop = (MapProperty)p;
            this.name = (String)((Object)this.prop.get("name").getValue());
            this.label = (String)((Object)this.prop.get("label").getValue());
            this.filter = (String)((Object)this.prop.get(GraphNode.PROP_BTN_FILTER).getValue());
        }

        @Override
        public int compareTo(Button other) {
            return this.name.compareTo(other.name);
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    public static class Transition
    implements Comparable<Transition> {
        public GraphNode source;
        public MapProperty prop;
        public String id;
        public String condition;
        public String chain;
        public String target;
        public String label;
        public boolean result;
        public boolean loop;

        protected Transition(GraphNode source, Property p) throws ClientException {
            this.source = source;
            this.prop = (MapProperty)p;
            this.id = (String)((Object)this.prop.get("name").getValue());
            this.condition = (String)((Object)this.prop.get(GraphNode.PROP_TRANS_CONDITION).getValue());
            this.chain = (String)((Object)this.prop.get(GraphNode.PROP_TRANS_CHAIN).getValue());
            this.target = (String)((Object)this.prop.get(GraphNode.PROP_TRANS_TARGET).getValue());
            this.label = (String)((Object)this.prop.get("label").getValue());
            Property resultProp = this.prop.get(GraphNode.PROP_TRANS_RESULT);
            if (resultProp != null) {
                this.result = BooleanUtils.isTrue((Boolean)((Boolean)resultProp.getValue(Boolean.class)));
            }
        }

        protected void setResult(boolean bool) throws ClientException {
            this.result = bool;
            this.prop.get(GraphNode.PROP_TRANS_RESULT).setValue((Object)bool);
        }

        @Override
        public int compareTo(Transition other) {
            return this.id.compareTo(other.id);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("id", (Object)this.id).append(GraphNode.PROP_TRANS_CONDITION, (Object)this.condition).append(GraphNode.PROP_TRANS_RESULT, this.result).toString();
        }

        public String getTarget() {
            return this.target;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum State {
        READY("ready", "toReady"),
        WAITING("waiting", "toWaiting"),
        RUNNING_INPUT,
        SUSPENDED("suspended", "toSuspended"),
        RUNNING_OUTPUT;

        private final String lifeCycleState;
        private final String transition;

        private State() {
            this.lifeCycleState = null;
            this.transition = null;
        }

        private State(String lifeCycleState, String transition) {
            this.lifeCycleState = lifeCycleState;
            this.transition = transition;
        }

        public String getLifeCycleState() {
            return this.lifeCycleState;
        }

        public String getTransition() {
            return this.transition;
        }

        public static State fromString(String s) {
            try {
                return State.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(s);
            }
        }
    }
}

