/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.server.jaxrs.ExceptionHandler;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestCleanupHandler;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.runtime.api.Framework;

public class BatchResource {
    private static final String REQUEST_BATCH_ID = "batchId";
    protected static final Log log = LogFactory.getLog(BatchResource.class);

    public CoreSession getCoreSession(HttpServletRequest request) {
        return SessionFactory.getSession((HttpServletRequest)request);
    }

    protected Response buildFromString(String message) {
        return Response.ok((Object)message, (String)"application/json").header("Content-Length", (Object)message.length()).build();
    }

    protected int getUploadWaitTimeout() {
        String t = Framework.getProperty((String)"org.nuxeo.batch.upload.wait.timeout", (String)"5");
        return Integer.parseInt(t);
    }

    @POST
    @Path(value="upload")
    public Object doPost(@Context HttpServletRequest request) throws Exception {
        String fileName = request.getHeader("X-File-Name");
        String fileSize = request.getHeader("X-File-Size");
        String batchId = request.getHeader("X-Batch-Id");
        String mimeType = request.getHeader("X-File-Type");
        String idx = request.getHeader("X-File-Idx");
        fileName = URLDecoder.decode(fileName, "UTF-8");
        ServletInputStream is = request.getInputStream();
        log.debug((Object)("uploaded " + fileName + " (" + fileSize + "b)"));
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        bm.addStream(batchId, idx, (InputStream)is, fileName, mimeType);
        return this.buildFromString("uploaded");
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="execute")
    public Object exec(@Context HttpServletRequest request, ExecutionRequest xreq) throws Exception {
        Map<String, Object> params = xreq.getParams();
        String batchId = (String)params.get(REQUEST_BATCH_ID);
        String operationId = (String)params.get("operationId");
        params.remove(REQUEST_BATCH_ID);
        params.remove("operationId");
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        List<Blob> blobs = bm.getBlobs(batchId, this.getUploadWaitTimeout());
        if (blobs == null) {
            log.error((Object)("Unable to find batch associated with id " + batchId));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\" : \"Unable to find batch with Id " + batchId + "\"}")).build();
        }
        xreq.setInput(new BlobList(blobs));
        OperationContext ctx = xreq.createContext(request, this.getCoreSession(request));
        AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
        request.setAttribute(REQUEST_BATCH_ID, (Object)batchId);
        RequestContext.getActiveContext((ServletRequest)request).addRequestCleanupHandler(new RequestCleanupHandler(){

            public void cleanup(HttpServletRequest req) {
                String bid = (String)req.getAttribute(BatchResource.REQUEST_BATCH_ID);
                BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
                bm.clean(bid);
            }
        });
        try {
            Object result = null;
            if (operationId.startsWith("Chain.")) {
                ctx.putAll(xreq.getParams());
                result = as.run(ctx, operationId.substring(6));
            } else {
                OperationChain chain = new OperationChain("operation");
                OperationParameters oparams = new OperationParameters(operationId, params);
                chain.add(oparams);
                result = as.run(ctx, chain);
            }
            if ("true".equals(request.getHeader("X-NXVoidOperation"))) {
                return ResponseHelper.emptyContent();
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Error while executing automation batch ", (Throwable)e);
            if (ExceptionHandler.isSecurityError(e)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"error\" : \"" + e.getMessage() + "\"}")).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\" : \"" + e.getMessage() + "\"}")).build();
        }
    }

    @GET
    @Path(value="drop/{batchId}")
    public Object dropBatch(@PathParam(value="batchId") String batchId) throws Exception {
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        bm.clean(batchId);
        return this.buildFromString("Batch droped");
    }
}

