/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;

public class ValueExpressionHelper {
    private ValueExpressionHelper() {
    }

    public static boolean isFormattedAsELExpression(String expression) {
        return expression.contains(".") || expression.contains("[");
    }

    public static String createBareExpressionString(String valueName, FieldDefinition field) {
        String[] splittedFieldName;
        String propertyName;
        String[] s;
        if (field == null || "".equals(field.getPropertyName())) {
            return valueName;
        }
        String fieldName = field.getFieldName();
        if (ComponentTagUtils.isStrictValueReference((String)fieldName)) {
            return ComponentTagUtils.getBareValueName((String)fieldName);
        }
        if (ValueExpressionHelper.isFormattedAsELExpression(fieldName)) {
            String format = "%s.%s";
            if (fieldName.startsWith(".") || fieldName.startsWith("[")) {
                format = "%s%s";
            }
            return String.format(format, valueName, fieldName);
        }
        ArrayList<String> expressionElements = new ArrayList<String>();
        expressionElements.add(valueName);
        String schemaName = field.getSchemaName();
        if (schemaName == null && (s = (propertyName = field.getFieldName()).split(":")).length == 2) {
            schemaName = s[0];
            fieldName = s[1];
        }
        if (schemaName != null) {
            expressionElements.add(String.format("['%s']", schemaName));
        }
        for (String item : splittedFieldName = fieldName.split("/")) {
            try {
                expressionElements.add(String.format("[%s]", Integer.parseInt(item)));
            }
            catch (NumberFormatException e) {
                expressionElements.add(String.format("['%s']", item));
            }
        }
        return StringUtils.join(expressionElements, (String)"");
    }

    public static String createExpressionString(String valueName, FieldDefinition field) {
        String bareExpression = ValueExpressionHelper.createBareExpressionString(valueName, field);
        return String.format("#{%s}", bareExpression);
    }
}

