/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mock;

import com.phloc.commons.ICloneable;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.io.streamprovider.ByteArrayInputStreamProvider;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.MicroTypeConverter;
import com.phloc.commons.microdom.serialize.MicroWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.junit.Assert;

@Immutable
public final class PhlocTestUtils {
    private static final PhlocTestUtils s_aInstance = new PhlocTestUtils();

    private PhlocTestUtils() {
    }

    private static void _assertTrue(@Nonnull String string, boolean bl) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    private static void _assertFalse(@Nonnull String string, boolean bl) {
        if (bl) {
            throw new IllegalStateException(string);
        }
    }

    private static void _assertNotNull(@Nonnull String string, Object object) {
        if (object == null) {
            throw new IllegalStateException(string);
        }
    }

    private static <T> void _assertEquals(@Nonnull String string, @Nullable T t, @Nullable T t2) {
        if (!EqualsUtils.equals(t, t2)) {
            throw new IllegalStateException(string + "\nOBJ1: " + t + "\nOBJ2: " + t2);
        }
    }

    @SuppressFBWarnings(value={"EC_NULL_ARG"})
    private static <DATATYPE> void _testEqualsImplementation(@Nonnull DATATYPE DATATYPE) {
        PhlocTestUtils._assertNotNull("Passed object may not be null!", DATATYPE);
        PhlocTestUtils._assertTrue("Passed objects are not equal", DATATYPE.equals(DATATYPE));
        PhlocTestUtils._assertFalse("Object may no be equal to String", DATATYPE.equals("any string"));
        PhlocTestUtils._assertFalse("Object may no be equal to null", DATATYPE.equals(null));
    }

    private static <DATATYPE> void _testEqualsImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils._testEqualsImplementation(DATATYPE);
        PhlocTestUtils._testEqualsImplementation(DATATYPE2);
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        PhlocTestUtils._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        PhlocTestUtils._assertTrue("Passed objects are not identical!", DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testEqualsImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils._testEqualsImplementation(DATATYPE);
        PhlocTestUtils._testEqualsImplementation(DATATYPE2);
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        PhlocTestUtils._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        PhlocTestUtils._assertFalse("Passed objects are identical!", DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testHashcodeImplementation(@Nonnull DATATYPE DATATYPE) {
        PhlocTestUtils._assertNotNull("Passed object may not be null!", DATATYPE);
        PhlocTestUtils._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE.hashCode());
        PhlocTestUtils._assertFalse("hashCode() may not be 0", DATATYPE.hashCode() == 0);
    }

    private static <DATATYPE> void _testHashcodeImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils._testHashcodeImplementation(DATATYPE);
        PhlocTestUtils._testHashcodeImplementation(DATATYPE2);
        PhlocTestUtils._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        PhlocTestUtils._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE2.hashCode());
        PhlocTestUtils._assertTrue("hashCode() invocations must be consistent", DATATYPE2.hashCode() == DATATYPE.hashCode());
    }

    private static <DATATYPE> void _testHashcodeImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils._testHashcodeImplementation(DATATYPE);
        PhlocTestUtils._testHashcodeImplementation(DATATYPE2);
        PhlocTestUtils._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        int n = DATATYPE.hashCode();
        int n2 = DATATYPE2.hashCode();
        PhlocTestUtils._assertFalse("hashCode() may not be the same for both objects", n == n2);
    }

    public static <DATATYPE> void testToStringImplementation(@Nonnull DATATYPE DATATYPE) {
        PhlocTestUtils._assertNotNull("Passed object may not be null!", DATATYPE);
        PhlocTestUtils._assertNotNull("toString() may not return null!", DATATYPE.toString());
        PhlocTestUtils._assertTrue("toString() may not return an empty string!", DATATYPE.toString().length() > 0);
        PhlocTestUtils._assertTrue("toString() invocations must be consistent", DATATYPE.toString().equals(DATATYPE.toString()));
    }

    private static <DATATYPE> void _testToStringImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils.testToStringImplementation(DATATYPE);
        PhlocTestUtils.testToStringImplementation(DATATYPE2);
        PhlocTestUtils._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    private static <DATATYPE> void _testToStringImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils.testToStringImplementation(DATATYPE);
        PhlocTestUtils.testToStringImplementation(DATATYPE2);
        PhlocTestUtils._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        PhlocTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils._testEqualsImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        PhlocTestUtils._testHashcodeImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        PhlocTestUtils._testToStringImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PhlocTestUtils._testEqualsImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        PhlocTestUtils._testHashcodeImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        PhlocTestUtils._testToStringImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <DATATYPE extends Serializable> DATATYPE testDefaultSerialization(@Nonnull DATATYPE DATATYPE) {
        try {
            Serializable serializable;
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(nonBlockingByteArrayOutputStream);
            try {
                objectOutputStream.writeObject(DATATYPE);
            }
            finally {
                StreamUtils.close(objectOutputStream);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStreamProvider(nonBlockingByteArrayOutputStream.toByteArray()).getInputStream());
            try {
                serializable = (Serializable)GenericReflection.uncheckedCast(objectInputStream.readObject());
            }
            finally {
                StreamUtils.close(objectInputStream);
            }
            PhlocTestUtils.testDefaultImplementationWithEqualContentObject(DATATYPE, serializable);
            return (DATATYPE)serializable;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("testDefaultSerialization failed", throwable);
        }
    }

    public static void testGetClone(@Nonnull ICloneable<?> iCloneable) {
        Object obj = iCloneable.getClone();
        PhlocTestUtils._assertNotNull("Clone returned a null object", obj);
        PhlocTestUtils._assertTrue("Clone returned a different class than the original one", obj.getClass().equals(iCloneable.getClass()));
        PhlocTestUtils.testDefaultImplementationWithEqualContentObject(iCloneable, obj);
    }

    public static void testMicroTypeConversion(@Nonnull Object object) {
        Assert.assertNotNull((Object)object);
        IMicroElement iMicroElement = MicroTypeConverter.convertToMicroElement(object, "test");
        Assert.assertNotNull((Object)iMicroElement);
        Object obj = MicroTypeConverter.convertToNative(iMicroElement, object.getClass());
        Assert.assertNotNull(obj);
        IMicroElement iMicroElement2 = MicroTypeConverter.convertToMicroElement(obj, "test");
        Assert.assertNotNull((Object)iMicroElement2);
        String string = MicroWriter.getXMLString(iMicroElement);
        String string2 = MicroWriter.getXMLString(iMicroElement2);
        PhlocTestUtils._assertEquals("XML representation must be identical", string, string2);
        PhlocTestUtils.testDefaultImplementationWithEqualContentObject(object, obj);
    }
}

