/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats.utils;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedSize;
import com.phloc.commons.stats.IStatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.visit.IStatisticsVisitor;
import javax.annotation.Nonnull;

public final class StatisticsVisitorToXML
implements IStatisticsVisitor {
    private final IMicroElement m_eRoot;

    public StatisticsVisitorToXML(@Nonnull IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            throw new NullPointerException("root");
        }
        this.m_eRoot = iMicroElement;
    }

    @Override
    public void onCache(String string, IStatisticsHandlerCache iStatisticsHandlerCache) {
        if (iStatisticsHandlerCache.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("cache").setAttribute("name", string).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerCache.getInvocationCount())).setAttribute("hits", Integer.toString(iStatisticsHandlerCache.getHits())).setAttribute("misses", Integer.toString(iStatisticsHandlerCache.getMisses()));
        }
    }

    @Override
    public void onTimer(String string, IStatisticsHandlerTimer iStatisticsHandlerTimer) {
        if (iStatisticsHandlerTimer.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("timer").setAttribute("name", string).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerTimer.getInvocationCount())).setAttribute("min", Long.toString(iStatisticsHandlerTimer.getMin())).setAttribute("average", Long.toString(iStatisticsHandlerTimer.getAverage())).setAttribute("max", Long.toString(iStatisticsHandlerTimer.getMax())).setAttribute("sum", iStatisticsHandlerTimer.getSum().toString());
        }
    }

    @Override
    public void onKeyedTimer(String string, IStatisticsHandlerKeyedTimer iStatisticsHandlerKeyedTimer) {
        if (iStatisticsHandlerKeyedTimer.getInvocationCount() > 0) {
            IMicroElement iMicroElement = this.m_eRoot.appendElement("keyedtimer").setAttribute("name", string).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerKeyedTimer.getInvocationCount()));
            for (String string2 : ContainerHelper.getSorted(iStatisticsHandlerKeyedTimer.getAllKeys())) {
                iMicroElement.appendElement("key").setAttribute("name", string2).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerKeyedTimer.getInvocationCount(string2))).setAttribute("min", Long.toString(iStatisticsHandlerKeyedTimer.getMin(string2))).setAttribute("average", Long.toString(iStatisticsHandlerKeyedTimer.getAverage(string2))).setAttribute("max", Long.toString(iStatisticsHandlerKeyedTimer.getMax(string2))).setAttribute("sum", iStatisticsHandlerKeyedTimer.getSum(string2).toString());
            }
        }
    }

    @Override
    public void onSize(String string, IStatisticsHandlerSize iStatisticsHandlerSize) {
        if (iStatisticsHandlerSize.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("size").setAttribute("name", string).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerSize.getInvocationCount())).setAttribute("min", Long.toString(iStatisticsHandlerSize.getMin())).setAttribute("average", Long.toString(iStatisticsHandlerSize.getAverage())).setAttribute("max", Long.toString(iStatisticsHandlerSize.getMax())).setAttribute("sum", iStatisticsHandlerSize.getSum().toString());
        }
    }

    @Override
    public void onKeyedSize(String string, IStatisticsHandlerKeyedSize iStatisticsHandlerKeyedSize) {
        if (iStatisticsHandlerKeyedSize.getInvocationCount() > 0) {
            IMicroElement iMicroElement = this.m_eRoot.appendElement("keyedsize").setAttribute("name", string).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerKeyedSize.getInvocationCount()));
            for (String string2 : ContainerHelper.getSorted(iStatisticsHandlerKeyedSize.getAllKeys())) {
                iMicroElement.appendElement("key").setAttribute("name", string2).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerKeyedSize.getInvocationCount(string2))).setAttribute("min", Long.toString(iStatisticsHandlerKeyedSize.getMin(string2))).setAttribute("average", Long.toString(iStatisticsHandlerKeyedSize.getAverage(string2))).setAttribute("max", Long.toString(iStatisticsHandlerKeyedSize.getMax(string2))).setAttribute("sum", iStatisticsHandlerKeyedSize.getSum(string2).toString());
            }
        }
    }

    @Override
    public void onCounter(String string, IStatisticsHandlerCounter iStatisticsHandlerCounter) {
        if (iStatisticsHandlerCounter.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("counter").setAttribute("name", string).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerCounter.getInvocationCount())).setAttribute("count", Long.toString(iStatisticsHandlerCounter.getCount()));
        }
    }

    @Override
    public void onKeyedCounter(String string, IStatisticsHandlerKeyedCounter iStatisticsHandlerKeyedCounter) {
        if (iStatisticsHandlerKeyedCounter.getInvocationCount() > 0) {
            IMicroElement iMicroElement = this.m_eRoot.appendElement("keyedcounter").setAttribute("name", string).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerKeyedCounter.getInvocationCount()));
            for (String string2 : ContainerHelper.getSorted(iStatisticsHandlerKeyedCounter.getAllKeys())) {
                iMicroElement.appendElement("key").setAttribute("name", string2).setAttribute("invocationcount", Integer.toString(iStatisticsHandlerKeyedCounter.getInvocationCount(string2))).setAttribute("count", Long.toString(iStatisticsHandlerKeyedCounter.getCount(string2)));
            }
        }
    }
}

