/*
 * Decompiled with CFR 0.152.
 */
package org.artofsolving.jodconverter.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformUtils {
    private static final Logger logger = Logger.getLogger(PlatformUtils.class.getName());
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String WINDOWS = "windows";
    private static final String MAC = "mac";
    private static final String LINUX = "linux";
    private static final String[] LINUX_OO_HOME_PATHS = new String[]{"/usr/lib/libreoffice", "/opt/libreoffice4.0", "/usr/lib/openoffice", "/usr/lib/openoffice.org", "/usr/lib/openoffice.org3", "/opt/openoffice.org3", "/opt/libreoffice", "/usr/lib/ooo"};
    private static final String[] MAC_OO_HOME_PATHS = new String[]{"/Applications/LibreOffice.app/Contents", "/Applications/OpenOffice.org.app/Contents"};
    private static final String[] WINDOWS_OO_HOME_PATHS = new String[]{System.getenv("ProgramFiles") + File.separator + "LibreOffice 4.5", System.getenv("ProgramFiles") + File.separator + "LibreOffice 4.4", System.getenv("ProgramFiles") + File.separator + "LibreOffice 4.3", System.getenv("ProgramFiles") + File.separator + "LibreOffice 4.2", System.getenv("ProgramFiles") + File.separator + "LibreOffice 4.1", System.getenv("ProgramFiles") + File.separator + "LibreOffice 4.0", System.getenv("ProgramFiles") + File.separator + "LibreOffice 3.9", System.getenv("ProgramFiles") + File.separator + "LibreOffice 3.8", System.getenv("ProgramFiles") + File.separator + "LibreOffice 3.7", System.getenv("ProgramFiles") + File.separator + "LibreOffice 3.6", System.getenv("ProgramFiles") + File.separator + "LibreOffice 3.5", System.getenv("ProgramFiles") + File.separator + "LibreOffice 3.4", System.getenv("ProgramFiles") + File.separator + "LibreOffice 3", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 4.5", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 4.4", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 4.3", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 4.2", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 4.1", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 4.0", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 3.9", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 3.8", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 3.7", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 3.6", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 3.5", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 3.4", System.getenv("ProgramFiles(x86)") + File.separator + "LibreOffice 3", System.getenv("ProgramFiles") + File.separator + "OpenOffice.org 3", System.getenv("ProgramFiles(x86)") + File.separator + "OpenOffice.org 3"};
    private static final String[] LINUX_OO_PROFILE_PATHS = new String[]{System.getProperty("user.home") + File.separator + ".libreoffice/4", System.getProperty("user.home") + File.separator + ".libreoffice/3", System.getProperty("user.home") + File.separator + ".openoffice.org/3"};
    private static final String[] MAC_OO_PROFILE_PATHS = new String[]{System.getProperty("user.home") + File.separator + "Library/Application Support/LibreOffice.org/4", System.getProperty("user.home") + File.separator + "Library/Application Support/LibreOffice.org/3", System.getProperty("user.home") + File.separator + "Library/Application Support/OpenOffice.org/3"};
    private static final String[] WINDOWS_OO_PROFILE_PATHS = new String[]{System.getenv("APPDATA") + File.separator + "LibreOffice.org/4", System.getenv("APPDATA") + File.separator + "LibreOffice.org/3", System.getenv("APPDATA") + File.separator + "OpenOffice.org/3"};
    private static String officeProfileDir = null;
    private static String officeHome = null;

    private PlatformUtils() {
        throw new AssertionError((Object)"utility class must not be instantiated");
    }

    public static boolean isLinux() {
        return OS_NAME.startsWith(LINUX);
    }

    public static boolean isMac() {
        return OS_NAME.startsWith(MAC);
    }

    public static boolean isWindows() {
        return OS_NAME.startsWith(WINDOWS);
    }

    public static String findOfficeHome() {
        if (officeHome == null) {
            String[] homeList = new String[]{};
            if (PlatformUtils.isLinux()) {
                homeList = LINUX_OO_HOME_PATHS;
            } else if (PlatformUtils.isMac()) {
                homeList = MAC_OO_HOME_PATHS;
            } else if (PlatformUtils.isWindows()) {
                homeList = WINDOWS_OO_HOME_PATHS;
            }
            officeHome = PlatformUtils.searchExistingfile(Arrays.asList(homeList));
        }
        return officeHome;
    }

    public static String findOfficeProfileDir() {
        if (officeProfileDir == null) {
            String[] profileDirList = new String[]{};
            if (PlatformUtils.isLinux()) {
                profileDirList = LINUX_OO_PROFILE_PATHS;
            } else if (PlatformUtils.isMac()) {
                profileDirList = MAC_OO_PROFILE_PATHS;
            } else if (PlatformUtils.isWindows()) {
                profileDirList = WINDOWS_OO_PROFILE_PATHS;
            }
            officeProfileDir = PlatformUtils.searchExistingfile(Arrays.asList(profileDirList));
        }
        return officeProfileDir;
    }

    protected static String searchExistingfile(List<String> pathList) {
        for (String path : pathList) {
            if (!new File(path).exists()) continue;
            logger.info("Jod will be using " + path);
            return path;
        }
        return "";
    }
}

