/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.annotation.ExceptionMetered;
import com.yammer.metrics.annotation.Gauge;
import com.yammer.metrics.annotation.Metered;
import com.yammer.metrics.annotation.Timed;
import java.lang.reflect.Method;

public class MetricName
implements Comparable<MetricName> {
    private final String domain;
    private final String type;
    private final String name;
    private final String scope;

    public MetricName(Class<?> klass, String name) {
        this(klass, name, null);
    }

    public MetricName(String domain, String type, String name) {
        this(domain, type, name, null);
    }

    public MetricName(Class<?> klass, String name, String scope) {
        this(MetricName.getPackageName(klass), MetricName.getClassName(klass), name, scope);
    }

    public MetricName(String domain, String type, String name, String scope) {
        if (domain == null || type == null) {
            throw new IllegalArgumentException("Both domain and type need to be specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name needs to be specified");
        }
        this.domain = domain;
        this.type = type;
        this.name = name;
        this.scope = scope;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricName that = (MetricName)o;
        return this.domain.equals(that.domain) && this.name.equals(that.name) && this.type.equals(that.type) && (this.scope == null ? that.scope == null : this.scope.equals(that.scope));
    }

    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.domain + '.' + this.type + '.' + this.name + (this.scope == null ? "" : '.' + this.scope);
    }

    @Override
    public int compareTo(MetricName o) {
        int result = this.domain.compareTo(o.domain);
        if (result != 0) {
            return result;
        }
        result = this.type.compareTo(o.type);
        if (result != 0) {
            return result;
        }
        result = this.name.compareTo(o.name);
        if (result != 0) {
            return result;
        }
        if (this.scope == null) {
            if (o.scope != null) {
                return -1;
            }
            return 0;
        }
        if (o.scope != null) {
            return this.scope.compareTo(o.scope);
        }
        return 1;
    }

    private static String getPackageName(Class<?> klass) {
        return klass.getPackage() == null ? "" : klass.getPackage().getName();
    }

    private static String getClassName(Class<?> klass) {
        return klass.getSimpleName().replaceAll("\\$$", "");
    }

    private static String chooseDomain(String domain, Class<?> klass) {
        if (domain == null || domain.isEmpty()) {
            domain = MetricName.getPackageName(klass);
        }
        return domain;
    }

    private static String chooseType(String type, Class<?> klass) {
        if (type == null || type.isEmpty()) {
            type = MetricName.getClassName(klass);
        }
        return type;
    }

    private static String chooseName(String name, Method method) {
        if (name == null || name.isEmpty()) {
            name = method.getName();
        }
        return name;
    }

    public static MetricName forTimedMethod(Class<?> klass, Method method, Timed annotation) {
        return new MetricName(MetricName.chooseDomain(annotation.group(), klass), MetricName.chooseType(annotation.type(), klass), MetricName.chooseName(annotation.name(), method));
    }

    public static MetricName forMeteredMethod(Class<?> klass, Method method, Metered annotation) {
        return new MetricName(MetricName.chooseDomain(annotation.group(), klass), MetricName.chooseType(annotation.type(), klass), MetricName.chooseName(annotation.name(), method));
    }

    public static MetricName forGaugeMethod(Class<?> klass, Method method, Gauge annotation) {
        return new MetricName(MetricName.chooseDomain(annotation.group(), klass), MetricName.chooseType(annotation.type(), klass), MetricName.chooseName(annotation.name(), method));
    }

    public static MetricName forExceptionMeteredMethod(Class<?> klass, Method method, ExceptionMetered annotation) {
        return new MetricName(MetricName.chooseDomain(annotation.group(), klass), MetricName.chooseType(annotation.type(), klass), annotation.name() == null || annotation.name().isEmpty() ? method.getName() + "Exceptions" : annotation.name());
    }
}

