/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationTreeNotAvailable;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublisherException;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.api.PublishingEvent;
import org.nuxeo.ecm.platform.publisher.web.AbstractPublishActions;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="publishActions")
@Scope(value=ScopeType.CONVERSATION)
public class PublishActionsBean
extends AbstractPublishActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PublishActionsBean.class);
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    protected transient PublisherService publisherService;
    protected String currentPublicationTreeNameForPublishing;
    protected PublicationTree currentPublicationTree;
    protected String publishingComment;
    protected static Set<String> sectionTypes;
    protected Map<String, String> publicationParameters = new HashMap<String, String>();
    protected String treeSID;

    @Create
    public void create() {
        try {
            this.publisherService = (PublisherService)Framework.getService(PublisherService.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Publisher service not deployed.", e);
        }
    }

    @Destroy
    public void destroy() {
        if (this.currentPublicationTree != null) {
            this.currentPublicationTree.release();
            this.currentPublicationTree = null;
        }
        if (this.treeSID != null) {
            this.publisherService.releaseAllTrees(this.treeSID);
        }
    }

    protected Map<String, String> filterEmptyTrees(Map<String, String> trees) throws PublicationTreeNotAvailable, ClientException {
        HashMap<String, String> filteredTrees = new HashMap<String, String>();
        List<String> prefilteredTrees = this.filterEmptyTrees(trees.keySet());
        for (String ptree : prefilteredTrees) {
            filteredTrees.put(ptree, trees.get(ptree));
        }
        return filteredTrees;
    }

    protected List<String> filterEmptyTrees(Collection<String> trees) throws PublicationTreeNotAvailable, ClientException {
        ArrayList<String> filteredTrees = new ArrayList<String>();
        for (String tree : trees) {
            try {
                PublicationTree pTree = this.publisherService.getPublicationTree(tree, this.documentManager, null, this.navigationContext.getCurrentDocument());
                if (pTree == null) continue;
                if (pTree.getTreeType().equals("RootSectionsPublicationTree")) {
                    if (pTree.getChildrenNodes().size() <= 0) continue;
                    filteredTrees.add(tree);
                    continue;
                }
                filteredTrees.add(tree);
            }
            catch (PublicationTreeNotAvailable e) {
                log.warn((Object)("Publication tree " + tree + " is not available : check config"));
                log.debug((Object)("Publication tree " + tree + " is not available : root cause is "), (Throwable)e);
            }
        }
        return filteredTrees;
    }

    @Factory(value="availablePublicationTrees", scope=ScopeType.EVENT)
    public List<PublicationTreeInformation> getAvailablePublicationTrees() throws ClientException {
        Map<String, String> trees = this.publisherService.getAvailablePublicationTrees();
        trees = this.filterEmptyTrees(trees);
        ArrayList<PublicationTreeInformation> treesInformation = new ArrayList<PublicationTreeInformation>();
        for (Map.Entry<String, String> entry : trees.entrySet()) {
            treesInformation.add(new PublicationTreeInformation(entry.getKey(), entry.getValue()));
        }
        return treesInformation;
    }

    public String doPublish(PublicationNode publicationNode) throws ClientException {
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        return this.doPublish(tree, publicationNode);
    }

    public String doPublish(PublicationTree tree, PublicationNode publicationNode) throws ClientException {
        PublishedDocument publishedDocument;
        if (tree == null) {
            return null;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        try {
            publishedDocument = tree.publish(currentDocument, publicationNode, this.publicationParameters);
        }
        catch (PublisherException e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get(e.getMessage()), new Object[0]);
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (publishedDocument.isPending()) {
            String comment = ComponentUtils.translate((FacesContext)context, (String)"publishing.waiting", (Object[])new Object[]{publicationNode.getPath(), tree.getConfigName()});
            this.notifyEvent(PublishingEvent.documentWaitingPublication.name(), null, comment, null, currentDocument);
            Events.instance().raiseEvent("documentSubmitedForPublication", new Object[0]);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_submitted_for_publication"), new Object[]{this.resourcesAccessor.getMessages().get(currentDocument.getType())});
        } else {
            String comment = ComponentUtils.translate((FacesContext)context, (String)"publishing.done", (Object[])new Object[]{publicationNode.getPath(), tree.getConfigName()});
            this.notifyEvent(PublishingEvent.documentPublished.name(), null, comment, null, currentDocument);
            Events.instance().raiseEvent("documentPublished", new Object[0]);
            Events.instance().raiseEvent("documentChanged", new Object[0]);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_published"), new Object[]{this.resourcesAccessor.getMessages().get(currentDocument.getType())});
        }
        this.currentPublicationTree = null;
        return null;
    }

    public void setCurrentPublicationTreeNameForPublishing(String currentPublicationTreeNameForPublishing) throws ClientException {
        this.currentPublicationTreeNameForPublishing = currentPublicationTreeNameForPublishing;
        if (this.currentPublicationTree != null) {
            this.currentPublicationTree.release();
            this.currentPublicationTree = null;
        }
        this.currentPublicationTree = this.getCurrentPublicationTreeForPublishing();
    }

    public String getCurrentPublicationTreeNameForPublishing() throws ClientException {
        if (this.currentPublicationTreeNameForPublishing == null) {
            List<String> publicationTrees = new ArrayList<String>(this.publisherService.getAvailablePublicationTree());
            if (!(publicationTrees = this.filterEmptyTrees(publicationTrees)).isEmpty()) {
                this.currentPublicationTreeNameForPublishing = publicationTrees.get(0);
            }
        }
        return this.currentPublicationTreeNameForPublishing;
    }

    public PublicationTree getCurrentPublicationTreeForPublishing() throws ClientException {
        if (this.currentPublicationTree == null) {
            String currentPublicationTreeNameForPublishing = this.getCurrentPublicationTreeNameForPublishing();
            if (currentPublicationTreeNameForPublishing == null) {
                return this.currentPublicationTree;
            }
            try {
                this.treeSID = this.documentManager.getSessionId();
                this.currentPublicationTree = this.publisherService.getPublicationTree(currentPublicationTreeNameForPublishing, this.documentManager, null, this.navigationContext.getCurrentDocument());
            }
            catch (PublicationTreeNotAvailable e) {
                this.currentPublicationTree = null;
            }
        }
        return this.currentPublicationTree;
    }

    public String getCurrentPublicationTreeIconExpanded() throws ClientException {
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        return tree != null ? tree.getIconExpanded() : "";
    }

    public String getCurrentPublicationTreeIconCollapsed() throws ClientException {
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        return tree != null ? tree.getIconCollapsed() : "";
    }

    @Factory(value="publishedDocuments", scope=ScopeType.EVENT)
    public List<PublishedDocument> getPublishedDocuments() throws ClientException {
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        if (tree == null) {
            return Collections.emptyList();
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return tree.getExistingPublishedDocument((DocumentLocation)new DocumentLocationImpl(currentDocument));
    }

    public List<PublishedDocument> getPublishedDocumentsFor(String treeName) throws ClientException {
        if (treeName == null || "".equals(treeName)) {
            return null;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        try {
            PublicationTree tree = this.publisherService.getPublicationTree(treeName, this.documentManager, null);
            return tree.getExistingPublishedDocument((DocumentLocation)new DocumentLocationImpl(currentDocument));
        }
        catch (PublicationTreeNotAvailable e) {
            return null;
        }
    }

    public String unPublish(PublishedDocument publishedDocument) throws ClientException {
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        if (tree != null) {
            tree.unpublish(publishedDocument);
        }
        Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        return null;
    }

    public String rePublish(PublishedDocument publishedDocument) throws ClientException {
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        if (tree != null) {
            for (PublicationNode node : tree.getChildrenNodes()) {
                if (!node.getPath().equals(publishedDocument.getParentPath())) continue;
                return this.doPublish(tree, node);
            }
        }
        this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("error.document_republished"), new Object[0]);
        return null;
    }

    public boolean canPublishTo(PublicationNode publicationNode) throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (doc == null || this.documentManager.getLockInfo(doc.getRef()) != null) {
            return false;
        }
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        return tree != null ? tree.canPublishTo(publicationNode) : false;
    }

    public boolean canUnpublish(PublishedDocument publishedDocument) throws ClientException {
        PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
        return tree != null ? tree.canUnpublish(publishedDocument) : false;
    }

    public boolean canRepublish(PublishedDocument publishedDocument) throws ClientException {
        if (!this.canUnpublish(publishedDocument)) {
            return false;
        }
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        if (!publishedDocument.getSourceVersionLabel().equals(doc.getVersionLabel())) {
            return true;
        }
        return doc.isDirty();
    }

    public boolean isPublishedDocument() {
        return this.publisherService.isPublishedDocument(this.navigationContext.getCurrentDocument());
    }

    public boolean canManagePublishing() throws ClientException {
        PublicationTree tree = this.publisherService.getPublicationTreeFor(this.navigationContext.getCurrentDocument(), this.documentManager);
        PublishedDocument publishedDocument = tree.wrapToPublishedDocument(this.navigationContext.getCurrentDocument());
        return tree.canManagePublishing(publishedDocument);
    }

    public boolean hasValidationTask() throws ClientException {
        PublicationTree tree = this.publisherService.getPublicationTreeFor(this.navigationContext.getCurrentDocument(), this.documentManager);
        PublishedDocument publishedDocument = tree.wrapToPublishedDocument(this.navigationContext.getCurrentDocument());
        return tree.hasValidationTask(publishedDocument);
    }

    public boolean isPending() throws ClientException {
        PublicationTree tree = this.publisherService.getPublicationTreeFor(this.navigationContext.getCurrentDocument(), this.documentManager);
        PublishedDocument publishedDocument = tree.wrapToPublishedDocument(this.navigationContext.getCurrentDocument());
        return publishedDocument.isPending();
    }

    public String getPublishingComment() {
        return this.publishingComment;
    }

    public void setPublishingComment(String publishingComment) {
        this.publishingComment = publishingComment;
    }

    public String approveDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        PublicationTree tree = this.publisherService.getPublicationTreeFor(currentDocument, this.documentManager);
        PublishedDocument publishedDocument = tree.wrapToPublishedDocument(currentDocument);
        tree.validatorPublishDocument(publishedDocument, this.publishingComment);
        FacesContext context = FacesContext.getCurrentInstance();
        String comment = this.publishingComment != null && this.publishingComment.length() > 0 ? ComponentUtils.translate((FacesContext)context, (String)"publishing.approved.with.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName(), this.publishingComment}) : ComponentUtils.translate((FacesContext)context, (String)"publishing.approved.without.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName()});
        ApproverWithoutRestriction approver = new ApproverWithoutRestriction(publishedDocument, comment, this.documentManager);
        if (this.documentManager.hasPermission(publishedDocument.getSourceDocumentRef(), "Write")) {
            approver.run();
        } else {
            approver.runUnrestricted();
        }
        Events.instance().raiseEvent("documentPublished", new Object[0]);
        Events.instance().raiseEvent("documentPublicationApproved", new Object[0]);
        return null;
    }

    public String rejectDocument() throws ClientException {
        if (this.publishingComment == null || "".equals(this.publishingComment)) {
            this.facesMessages.addToControl("publishingComment", StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.publishing.reject.user.comment.mandatory"), new Object[0]);
            return null;
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        PublicationTree tree = this.publisherService.getPublicationTreeFor(currentDocument, this.documentManager);
        PublishedDocument publishedDocument = tree.wrapToPublishedDocument(currentDocument);
        tree.validatorRejectPublication(publishedDocument, this.publishingComment);
        FacesContext context = FacesContext.getCurrentInstance();
        String comment = this.publishingComment != null && this.publishingComment.length() > 0 ? ComponentUtils.translate((FacesContext)context, (String)"publishing.rejected.with.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName(), this.publishingComment}) : ComponentUtils.translate((FacesContext)context, (String)"publishing.rejected.without.comment", (Object[])new Object[]{publishedDocument.getParentPath(), tree.getConfigName()});
        RejectWithoutRestrictionRunner runner = new RejectWithoutRestrictionRunner(this.documentManager, publishedDocument, comment);
        if (this.documentManager.hasPermission(publishedDocument.getSourceDocumentRef(), "Read")) {
            runner.run();
        } else {
            runner.runUnrestricted();
        }
        Events.instance().raiseEvent("documentPublicationRejected", new Object[0]);
        return this.navigationContext.navigateToRef(this.navigationContext.getCurrentDocument().getParentRef());
    }

    public void unpublishDocumentsFromCurrentSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_SECTIONS")) {
            this.unpublish(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS"));
        } else {
            log.debug((Object)"No selectable Documents in context to process unpublish on...");
        }
        log.debug((Object)"Unpublish the selected document(s) ...");
    }

    protected void unpublish(List<DocumentModel> documentModels) throws ClientException {
        for (DocumentModel documentModel : documentModels) {
            PublicationTree tree = this.publisherService.getPublicationTreeFor(documentModel, this.documentManager);
            PublishedDocument publishedDocument = tree.wrapToPublishedDocument(documentModel);
            tree.unpublish(publishedDocument);
        }
        Events.instance().raiseEvent("documentChildrenChanged", new Object[0]);
        Object[] params = new Object[]{documentModels.size()};
        this.documentsListsManager.resetWorkingList("CURRENT_SELECTION_SECTIONS");
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("n_unpublished_docs"), params);
    }

    public boolean isRemotePublishedDocument(PublishedDocument publishedDocument) {
        if (publishedDocument == null) {
            return false;
        }
        return publishedDocument.getType().equals((Object)PublishedDocument.Type.REMOTE);
    }

    public boolean isFileSystemPublishedDocument(PublishedDocument publishedDocument) {
        if (publishedDocument == null) {
            return false;
        }
        return publishedDocument.getType().equals((Object)PublishedDocument.Type.FILE_SYSTEM);
    }

    public boolean isLocalPublishedDocument(PublishedDocument publishedDocument) {
        if (publishedDocument == null) {
            return false;
        }
        return publishedDocument.getType().equals((Object)PublishedDocument.Type.LOCAL);
    }

    public String publishWorkList() throws ClientException {
        return this.publishDocumentList("DEFAULT");
    }

    public DocumentModel getDocumentModelFor(String path) throws ClientException {
        PathRef docRef = new PathRef(path);
        if (this.documentManager.exists((DocumentRef)docRef) && this.hasReadRight(path)) {
            return this.documentManager.getDocument((DocumentRef)docRef);
        }
        return null;
    }

    public boolean hasReadRight(String documentPath) throws ClientException {
        return this.documentManager.hasPermission((DocumentRef)new PathRef(documentPath), "Read");
    }

    public String getFormattedPath(String path) throws ClientException {
        DocumentModel docModel = this.getDocumentModelFor(path);
        return docModel != null ? this.getFormattedPath(docModel) : path;
    }

    public String publishDocumentList(String listName) throws ClientException {
        List docs2Publish = this.documentsListsManager.getWorkingList(listName);
        DocumentModel target = this.navigationContext.getCurrentDocument();
        if (!this.getSectionTypes().contains(target.getType())) {
            return null;
        }
        PublicationNode targetNode = this.publisherService.wrapToPublicationNode(target, this.documentManager);
        if (targetNode == null) {
            return null;
        }
        int nbPublishedDocs = 0;
        for (DocumentModel doc : docs2Publish) {
            if (!this.documentManager.hasPermission(doc.getRef(), "ReadProperties")) continue;
            if (doc.isProxy()) {
                this.documentManager.copy(doc.getRef(), target.getRef(), doc.getName());
                ++nbPublishedDocs;
                continue;
            }
            if (doc.hasFacet("Publishable")) {
                this.publisherService.publish(doc, targetNode);
                ++nbPublishedDocs;
                continue;
            }
            log.info((Object)("Attempted to publish non-publishable document " + doc.getTitle()));
        }
        Object[] params = new Object[]{nbPublishedDocs};
        this.facesMessages.add(StatusMessage.Severity.INFO, "#0 " + (String)this.resourcesAccessor.getMessages().get("n_published_docs"), params);
        if (nbPublishedDocs < docs2Publish.size()) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("selection_contains_non_publishable_docs"), new Object[0]);
        }
        EventManager.raiseEventsOnDocumentChildrenChange((DocumentModel)target);
        return null;
    }

    public Set<String> getSectionTypes() {
        if (sectionTypes == null && (sectionTypes = PublishActionsBean.getTypeNamesForFacet("PublishSpace")) == null) {
            sectionTypes = new HashSet<String>();
        }
        return sectionTypes;
    }

    protected static Set<String> getTypeNamesForFacet(String facetName) {
        SchemaManager schemaManager;
        try {
            schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            log.error((Object)"Exception in retrieving publish spaces : ", (Throwable)e);
            return null;
        }
        Set publishRoots = schemaManager.getDocumentTypeNamesForFacet(facetName);
        if (publishRoots == null || publishRoots.isEmpty()) {
            return null;
        }
        return publishRoots;
    }

    public Map<String, String> getPublicationParameters() {
        return this.publicationParameters;
    }

    public void notifyEvent(String eventId, Map<String, Serializable> properties, String comment, String category, DocumentModel dm) throws ClientException {
        PublishActionsBean.notifyEvent(this.documentManager, eventId, properties, comment, category, dm);
    }

    public static void notifyEvent(CoreSession session, String eventId, Map<String, Serializable> properties, String comment, String category, DocumentModel dm) throws ClientException {
        EventProducer evtProducer;
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        properties.put("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        properties.put("sessionId", (Serializable)((Object)session.getSessionId()));
        properties.put("documentLifeCycle", (Serializable)((Object)dm.getCurrentLifeCycleState()));
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), dm);
        ctx.setProperties(properties);
        ctx.setComment(comment);
        ctx.setCategory(category);
        try {
            evtProducer = (EventProducer)Framework.getService(EventProducer.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to access EventProducer", (Throwable)e);
            return;
        }
        Event event = ctx.newEvent(eventId);
        try {
            evtProducer.fireEvent(event);
        }
        catch (Exception e) {
            log.error((Object)"Error while sending event", (Throwable)e);
        }
    }

    public String getDomainName(String treeName) throws ClientException {
        try {
            PublicationTree tree = this.publisherService.getPublicationTree(treeName, this.documentManager, null);
            Map parameters = this.publisherService.getParametersFor(tree.getConfigName());
            String domainName = (String)parameters.get("DomainName");
            return domainName != null ? " (" + domainName + ")" : "";
        }
        catch (PublicationTreeNotAvailable e) {
            return "";
        }
    }

    @Observer(value={"documentSelectionChanged"}, create=false)
    @BypassInterceptors
    public void documentChanged() {
        this.currentPublicationTreeNameForPublishing = null;
        this.currentPublicationTree = null;
        this.publishingComment = null;
    }

    class RejectWithoutRestrictionRunner
    extends UnrestrictedSessionRunner {
        PublishedDocument publishedDocument;
        DocumentModel sourceDocument;
        DocumentModel liveDocument;
        String comment;
        DocumentModel liveVersion;

        public RejectWithoutRestrictionRunner(CoreSession session, PublishedDocument publishedDocument, String comment) {
            super(session);
            this.publishedDocument = publishedDocument;
            this.comment = comment;
        }

        public void run() throws ClientException {
            this.sourceDocument = this.session.getDocument(this.publishedDocument.getSourceDocumentRef());
            this.liveVersion = this.session.getDocument((DocumentRef)new IdRef(this.sourceDocument.getSourceId()));
            this.notifyRejectToSourceDocument();
        }

        private void notifyRejectToSourceDocument() throws ClientException {
            PublishActionsBean.this.notifyEvent(PublishingEvent.documentPublicationRejected.name(), null, this.comment, null, this.sourceDocument);
            if (!this.sourceDocument.getRef().equals(this.liveVersion.getRef())) {
                PublishActionsBean.this.notifyEvent(PublishingEvent.documentPublicationRejected.name(), null, this.comment, null, this.liveVersion);
            }
        }
    }

    public class ApproverWithoutRestriction
    extends UnrestrictedSessionRunner {
        public DocumentModel sourceDocument;
        public DocumentModel liveDocument;
        public String comment;
        public PublishedDocument doc;

        public ApproverWithoutRestriction(PublishedDocument doc, String comment, CoreSession session) {
            super(session);
            this.doc = doc;
            this.comment = comment;
        }

        public void run() throws ClientException {
            this.sourceDocument = this.session.getDocument(this.doc.getSourceDocumentRef());
            this.liveDocument = this.session.getSourceDocument(this.sourceDocument.getRef());
            this.sendApprovalEventToSourceDocument(this.session, this.sourceDocument, this.liveDocument, this.comment);
        }

        protected void sendApprovalEventToSourceDocument(CoreSession session, DocumentModel sourceDocument, DocumentModel liveVersion, String comment) throws ClientException {
            PublishActionsBean.notifyEvent(session, PublishingEvent.documentPublicationApproved.name(), null, comment, null, sourceDocument);
            if (!sourceDocument.getRef().equals(liveVersion.getRef())) {
                PublishActionsBean.notifyEvent(session, PublishingEvent.documentPublicationApproved.name(), null, comment, null, liveVersion);
            }
        }
    }

    public static class PublicationTreeInformation {
        private final String name;
        private final String title;

        public PublicationTreeInformation(String treeName, String treeTitle) {
            this.name = treeName;
            this.title = treeTitle;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

