/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreTypeMatchingRuleAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(StoreTypeMatchingRuleAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public StoreTypeMatchingRuleAction() {
        super("Store matching type Value");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            log.error("The type cannot be null in a MacthingRuleAssertion");
            throw new DecoderException("The type cannot be null in a MacthingRuleAssertion");
        }
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
        String type = StringTools.utf8ToString(tlv.getValue().getData());
        extensibleMatchFilter.setType(type);
        if (IS_DEBUG) {
            log.debug("Stored a type matching rule : {}", (Object)type);
        }
    }
}

