/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.serializer;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.syndication.FeedItem;
import org.nuxeo.ecm.platform.syndication.FeedItemAdapter;
import org.nuxeo.ecm.platform.syndication.serializer.AbstractDocumentModelSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;

public class AbstractSyndicationSerializer
extends AbstractDocumentModelSerializer {
    private String syndicationFormat = "rss_2.0";
    private static final String syndicationURL = "http://localhost:8080/nuxeo/restAPI/{repoId}/{docId}/{format}";

    @Override
    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) {
        List<FeedItem> syndicationEntries;
        if (docList == null) {
            return "empty result";
        }
        try {
            syndicationEntries = FeedItemAdapter.toFeedItemList((List<DocumentModel>)docList, req);
        }
        catch (Exception e) {
            return null;
        }
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType(this.syndicationFormat);
        feed.setTitle(summary.getTitle());
        feed.setLink(summary.getLink());
        if (summary.getDescription() != null) {
            feed.setDescription(summary.getDescription());
        } else {
            feed.setDescription(" ");
        }
        feed.setAuthor(summary.getAuthor());
        feed.setPublishedDate(summary.getModificationDate());
        feed.setEntries(syndicationEntries);
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString((SyndFeed)feed);
        }
        catch (FeedException fe) {
            return null;
        }
    }

    public String getSyndicationFormat() {
        return this.syndicationFormat;
    }

    public void setSyndicationFormat(String syndicationFormat) {
        this.syndicationFormat = syndicationFormat;
    }

    public String getSyndicationURL(String repository, String docId) {
        String url = syndicationURL.replace("{docId}", docId);
        url = url.replace("{repoId}", repository);
        url = url.replace("{format}", this.syndicationFormat);
        return url;
    }
}

