/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.plugins;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

public class FormAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final Log log = LogFactory.getLog(FormAuthenticator.class);
    protected String loginPage = "login.jsp";
    protected String usernameKey = "user_name";
    protected String passwordKey = "user_password";

    protected String getLoginPage() {
        return this.loginPage;
    }

    @Override
    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        try {
            String loginError;
            log.debug((Object)"Forward to Login Screen");
            HashMap<String, String> parameters = new HashMap<String, String>();
            String redirectUrl = baseURL + this.getLoginPage();
            Enumeration paramNames = httpRequest.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                String value = httpRequest.getParameter(name);
                parameters.put(name, value);
            }
            HttpSession session = httpRequest.getSession(false);
            String requestedUrl = null;
            if (session != null) {
                requestedUrl = (String)session.getAttribute("Nuxeo5_Start_Page");
            }
            if (requestedUrl != null && !requestedUrl.equals("")) {
                parameters.put("requestedUrl", URLEncoder.encode(requestedUrl, "UTF-8"));
            }
            if ((loginError = (String)httpRequest.getAttribute("org.nuxeo.ecm.login.error")) != null) {
                if ("username.missing".equals(loginError)) {
                    parameters.put("loginMissing", "true");
                } else if ("connection.error".equals(loginError)) {
                    parameters.put("connectionFailed", "true");
                    parameters.put("loginFailed", "true");
                } else {
                    parameters.put("loginFailed", "true");
                }
            }
            parameters.remove(this.passwordKey);
            redirectUrl = URIUtils.addParametersToURIQuery((String)redirectUrl, parameters);
            httpResponse.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        log.debug((Object)"Looking for user/password in the request");
        String userName = httpRequest.getParameter(this.usernameKey);
        String password = httpRequest.getParameter(this.passwordKey);
        if (httpRequest.getParameter("form_submitted_marker") != null && (userName == null || userName.length() == 0)) {
            httpRequest.setAttribute("org.nuxeo.ecm.login.error", (Object)"username.missing");
        }
        if (userName == null || userName.length() == 0) {
            return null;
        }
        return new UserIdentificationInfo(userName, password);
    }

    @Override
    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return true;
    }

    @Override
    public void initPlugin(Map<String, String> parameters) {
        if (parameters.get("LoginPage") != null) {
            this.loginPage = parameters.get("LoginPage");
        }
        if (parameters.get("UsernameKey") != null) {
            this.usernameKey = parameters.get("UsernameKey");
        }
        if (parameters.get("PasswordKey") != null) {
            this.passwordKey = parameters.get("PasswordKey");
        }
    }

    @Override
    public List<String> getUnAuthenticatedURLPrefix() {
        ArrayList<String> prefix = new ArrayList<String>();
        prefix.add(this.getLoginPage());
        return prefix;
    }
}

