/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.listener;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.VideoHelper;

public class VideoStoryboardListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) throws ClientException {
        if (!events.containsEventName("documentCreated") && !events.containsEventName("documentModified")) {
            return;
        }
        for (Event event : events) {
            if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName())) continue;
            this.handleEvent(event);
        }
    }

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("HasStoryboard") && ctx.hasProperty("videoChanged")) {
            BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
            VideoHelper.updateStoryboard(doc, blobHolder.getBlob());
            CoreSession session = docCtx.getCoreSession();
            session.saveDocument(doc);
            session.save();
        }
    }
}

