/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.NuxeoGroupImpl;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.DefaultUserMultiTenantManagement;
import org.nuxeo.ecm.platform.usermanager.MultiTenantUserManager;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserConfig;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.UserManagerDescriptor;
import org.nuxeo.ecm.platform.usermanager.UserMultiTenantManagement;
import org.nuxeo.ecm.platform.usermanager.VirtualUser;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.platform.usermanager.exceptions.UserAlreadyExistsException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;

public class UserManagerImpl
implements UserManager,
MultiTenantUserManager {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserManagerImpl.class);
    public static final String USERMANAGER_TOPIC = "usermanager";
    public static final String USERCHANGED_EVENT_ID = "user_changed";
    public static final String USERCREATED_EVENT_ID = "user_created";
    public static final String USERDELETED_EVENT_ID = "user_deleted";
    public static final String USERMODIFIED_EVENT_ID = "user_modified";
    public static final String GROUPCHANGED_EVENT_ID = "group_changed";
    public static final String GROUPCREATED_EVENT_ID = "group_created";
    public static final String GROUPDELETED_EVENT_ID = "group_deleted";
    public static final String GROUPMODIFIED_EVENT_ID = "group_modified";
    public static final String DEFAULT_ANONYMOUS_USER_ID = "Anonymous";
    public static final String VIRTUAL_FIELD_FILTER_PREFIX = "__";
    protected final DirectoryService dirService;
    public UserMultiTenantManagement multiTenantManagement = new DefaultUserMultiTenantManagement();
    protected UserConfig userConfig;
    protected String userDirectoryName;
    protected String userSchemaName;
    protected String userIdField;
    protected String userEmailField;
    protected Map<String, UserManager.MatchType> userSearchFields;
    protected String groupDirectoryName;
    protected String groupSchemaName;
    protected String groupIdField;
    protected String groupLabelField;
    protected String groupMembersField;
    protected String groupSubGroupsField;
    protected String groupParentGroupsField;
    protected String groupSortField;
    protected Map<String, UserManager.MatchType> groupSearchFields;
    protected String defaultGroup;
    protected List<String> administratorIds;
    protected List<String> administratorGroups;
    protected Boolean disableDefaultAdministratorsGroup;
    protected String userSortField;
    protected String userListingMode;
    protected String groupListingMode;
    protected Pattern userPasswordPattern;
    protected VirtualUser anonymousUser;
    protected String digestAuthDirectory;
    protected String digestAuthRealm;
    protected final Map<String, VirtualUserDescriptor> virtualUsers;

    public UserManagerImpl() {
        this.dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        this.virtualUsers = new HashMap<String, VirtualUserDescriptor>();
        this.userConfig = new UserConfig();
    }

    public void setConfiguration(UserManagerDescriptor descriptor) throws ClientException {
        this.defaultGroup = descriptor.defaultGroup;
        this.administratorIds = descriptor.defaultAdministratorIds;
        this.disableDefaultAdministratorsGroup = false;
        if (descriptor.disableDefaultAdministratorsGroup != null) {
            this.disableDefaultAdministratorsGroup = descriptor.disableDefaultAdministratorsGroup;
        }
        this.administratorGroups = new ArrayList<String>();
        if (!this.disableDefaultAdministratorsGroup.booleanValue()) {
            this.administratorGroups.add("administrators");
        }
        if (descriptor.administratorsGroups != null) {
            this.administratorGroups.addAll(descriptor.administratorsGroups);
        }
        if (this.administratorGroups.isEmpty()) {
            log.warn((Object)"No administrators group has been defined: at least one should be set to avoid lockups when blocking rights for instance");
        }
        this.userSortField = descriptor.userSortField;
        this.groupSortField = descriptor.groupSortField;
        this.userListingMode = descriptor.userListingMode;
        this.groupListingMode = descriptor.groupListingMode;
        this.userEmailField = descriptor.userEmailField;
        this.userSearchFields = descriptor.userSearchFields;
        this.userPasswordPattern = descriptor.userPasswordPattern;
        this.groupLabelField = descriptor.groupLabelField;
        this.groupMembersField = descriptor.groupMembersField;
        this.groupSubGroupsField = descriptor.groupSubGroupsField;
        this.groupParentGroupsField = descriptor.groupParentGroupsField;
        this.groupSearchFields = descriptor.groupSearchFields;
        this.anonymousUser = descriptor.anonymousUser;
        this.setUserDirectoryName(descriptor.userDirectoryName);
        this.setGroupDirectoryName(descriptor.groupDirectoryName);
        this.setVirtualUsers(descriptor.virtualUsers);
        this.digestAuthDirectory = descriptor.digestAuthDirectory;
        this.digestAuthRealm = descriptor.digestAuthRealm;
        this.userConfig = new UserConfig();
        this.userConfig.emailKey = this.userEmailField;
        this.userConfig.schemaName = this.userSchemaName;
        this.userConfig.nameKey = this.userIdField;
    }

    protected void setUserDirectoryName(String userDirectoryName) throws ClientException {
        this.userDirectoryName = userDirectoryName;
        this.userSchemaName = this.dirService.getDirectorySchema(userDirectoryName);
        this.userIdField = this.dirService.getDirectoryIdField(userDirectoryName);
    }

    public String getUserDirectoryName() {
        return this.userDirectoryName;
    }

    public String getUserIdField() throws ClientException {
        return this.userIdField;
    }

    public String getUserSchemaName() throws ClientException {
        return this.userSchemaName;
    }

    public String getUserEmailField() {
        return this.userEmailField;
    }

    public Set<String> getUserSearchFields() {
        return Collections.unmodifiableSet(this.userSearchFields.keySet());
    }

    public Set<String> getGroupSearchFields() {
        return Collections.unmodifiableSet(this.groupSearchFields.keySet());
    }

    protected void setGroupDirectoryName(String groupDirectoryName) {
        this.groupDirectoryName = groupDirectoryName;
        try {
            this.groupSchemaName = this.dirService.getDirectorySchema(groupDirectoryName);
            this.groupIdField = this.dirService.getDirectoryIdField(groupDirectoryName);
        }
        catch (ClientException e) {
            throw new RuntimeException("Unkown group directory " + groupDirectoryName, e);
        }
    }

    public String getGroupDirectoryName() {
        return this.groupDirectoryName;
    }

    public String getGroupIdField() throws ClientException {
        return this.groupIdField;
    }

    public String getGroupLabelField() throws ClientException {
        return this.groupLabelField;
    }

    public String getGroupSchemaName() throws ClientException {
        return this.groupSchemaName;
    }

    public String getGroupMembersField() {
        return this.groupMembersField;
    }

    public String getGroupSubGroupsField() {
        return this.groupSubGroupsField;
    }

    public String getGroupParentGroupsField() {
        return this.groupParentGroupsField;
    }

    public String getUserListingMode() {
        return this.userListingMode;
    }

    public String getGroupListingMode() {
        return this.groupListingMode;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public Pattern getUserPasswordPattern() {
        return this.userPasswordPattern;
    }

    public String getAnonymousUserId() {
        if (this.anonymousUser == null) {
            return null;
        }
        String anonymousUserId = this.anonymousUser.getId();
        if (anonymousUserId == null) {
            return DEFAULT_ANONYMOUS_USER_ID;
        }
        return anonymousUserId;
    }

    protected void setVirtualUsers(Map<String, VirtualUserDescriptor> virtualUsers) {
        this.virtualUsers.clear();
        if (virtualUsers != null) {
            this.virtualUsers.putAll(virtualUsers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUsernamePassword(String username, String password) throws ClientException {
        if (username == null || password == null) {
            log.warn((Object)"Trying to authenticate against null username or password");
            return false;
        }
        String anonymousUserId = this.getAnonymousUserId();
        if (username.equals(anonymousUserId)) {
            log.warn((Object)String.format("Trying to authenticate anonymous user (%s)", anonymousUserId));
            return false;
        }
        if (this.virtualUsers.containsKey(username)) {
            VirtualUser user = (VirtualUser)this.virtualUsers.get(username);
            String expected = user.getPassword();
            if (expected == null) {
                return false;
            }
            return expected.equals(password);
        }
        Session userDir = null;
        try {
            String userDirName = "userDirectory".equals(this.userDirectoryName) && this.dirService.getDirectory("userAuthentication") != null ? "userAuthentication" : this.userDirectoryName;
            userDir = this.dirService.open(userDirName);
            if (!userDir.isAuthenticating()) {
                log.error((Object)("Trying to authenticate against a non authenticating directory: " + userDirName));
                boolean bl = false;
                return bl;
            }
            boolean authenticated = userDir.authenticate(username, password);
            if (authenticated) {
                this.syncDigestAuthPassword(username, password);
            }
            boolean bl = authenticated;
            return bl;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncDigestAuthPassword(String username, String password) throws ClientException {
        if (StringUtils.isEmpty((String)this.digestAuthDirectory) || StringUtils.isEmpty((String)this.digestAuthRealm) || username == null || password == null) {
            return;
        }
        String ha1 = UserManagerImpl.encodeDigestAuthPassword(username, this.digestAuthRealm, password);
        Session dir = null;
        try {
            dir = this.dirService.open(this.digestAuthDirectory);
            String schema = this.dirService.getDirectorySchema(this.digestAuthDirectory);
            DocumentModel entry = dir.getEntry(username, true);
            if (entry == null) {
                entry = this.getDigestAuthModel();
                entry.setProperty(schema, dir.getIdField(), (Object)username);
                entry.setProperty(schema, dir.getPasswordField(), (Object)ha1);
                dir.createEntry(entry);
                dir.commit();
                log.debug((Object)("Created digest auth password for user:" + username));
            } else {
                String storedHa1 = (String)entry.getProperty(schema, dir.getPasswordField());
                if (!ha1.equals(storedHa1)) {
                    entry.setProperty(schema, dir.getPasswordField(), (Object)ha1);
                    dir.updateEntry(entry);
                    dir.commit();
                    log.debug((Object)("Updated digest auth password for user:" + username));
                }
            }
        }
        catch (DirectoryException e) {
            log.warn((Object)"Digest auth password not synchronized, check your configuration", (Throwable)e);
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    protected DocumentModel getDigestAuthModel() throws ClientException {
        String schema = this.dirService.getDirectorySchema(this.digestAuthDirectory);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    public static String encodeDigestAuthPassword(String username, String realm, String password) {
        String a1 = username + ":" + realm + ":" + password;
        return DigestUtils.md5Hex((String)a1);
    }

    public String getDigestAuthDirectory() {
        return this.digestAuthDirectory;
    }

    public String getDigestAuthRealm() {
        return this.digestAuthRealm;
    }

    public boolean validatePassword(String password) {
        if (this.userPasswordPattern == null) {
            return true;
        }
        Matcher userPasswordMatcher = this.userPasswordPattern.matcher(password);
        return userPasswordMatcher.find();
    }

    protected NuxeoPrincipal makeAnonymousPrincipal() throws ClientException {
        DocumentModel userEntry = this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser);
        return this.makePrincipal(userEntry, true, this.anonymousUser.getGroups());
    }

    protected NuxeoPrincipal makeVirtualPrincipal(VirtualUser user) throws ClientException {
        DocumentModel userEntry = this.makeVirtualUserEntry(user.getId(), user);
        return this.makePrincipal(userEntry, false, user.getGroups());
    }

    protected DocumentModel makeVirtualUserEntry(String id, VirtualUser user) throws ClientException {
        DocumentModel userEntry = BaseSession.createEntryModel(null, (String)this.userSchemaName, (String)id, null);
        userEntry.setProperty(this.userSchemaName, this.userIdField, (Object)id);
        for (Map.Entry prop : user.getProperties().entrySet()) {
            try {
                userEntry.setProperty(this.userSchemaName, (String)prop.getKey(), prop.getValue());
            }
            catch (ClientException ce) {
                log.error((Object)("Property: " + (String)prop.getKey() + " does not exists. Check your " + "UserService configuration."), (Throwable)ce);
            }
        }
        return userEntry;
    }

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry) throws ClientException {
        return this.makePrincipal(userEntry, false, null);
    }

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry, boolean anonymous, List<String> groups) throws ClientException {
        boolean admin = false;
        String username = userEntry.getId();
        LinkedList<String> virtualGroups = new LinkedList<String>();
        if (this.defaultGroup != null && !anonymous) {
            virtualGroups.add(this.defaultGroup);
        }
        if (groups != null) {
            virtualGroups.addAll(groups);
        }
        if (this.administratorIds != null && this.administratorIds.contains(username)) {
            admin = true;
            if (this.administratorGroups != null) {
                virtualGroups.addAll(this.administratorGroups);
            }
        }
        NuxeoPrincipalImpl principal = new NuxeoPrincipalImpl(username, anonymous, admin, false);
        principal.setConfig(this.userConfig);
        principal.setModel(userEntry, false);
        principal.setVirtualGroups(virtualGroups, true);
        List<String> roles = Arrays.asList("regular");
        principal.setRoles(roles);
        return principal;
    }

    public NuxeoPrincipal getPrincipal(String username) throws ClientException {
        return this.getPrincipal(username, null);
    }

    public DocumentModel getUserModel(String userName) throws ClientException {
        return this.getUserModel(userName, null);
    }

    public DocumentModel getBareUserModel() throws ClientException {
        String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    public NuxeoGroup getGroup(String groupName) throws ClientException {
        return this.getGroup(groupName, null);
    }

    protected NuxeoGroup getGroup(String groupName, DocumentModel context) throws ClientException {
        DocumentModel groupEntry = this.getGroupModel(groupName, context);
        if (groupEntry != null) {
            return this.makeGroup(groupEntry);
        }
        return null;
    }

    public DocumentModel getGroupModel(String groupName) throws ClientException {
        return this.getGroupModel(groupName, null);
    }

    protected NuxeoGroup makeGroup(DocumentModel groupEntry) {
        List list;
        NuxeoGroupImpl group = new NuxeoGroupImpl(groupEntry.getId());
        try {
            list = (List)groupEntry.getProperty(this.groupSchemaName, this.groupMembersField);
        }
        catch (ClientException e) {
            list = null;
        }
        if (list != null) {
            group.setMemberUsers(list);
        }
        try {
            list = (List)groupEntry.getProperty(this.groupSchemaName, this.groupSubGroupsField);
        }
        catch (ClientException e) {
            list = null;
        }
        if (list != null) {
            group.setMemberGroups(list);
        }
        try {
            list = (List)groupEntry.getProperty(this.groupSchemaName, this.groupParentGroupsField);
        }
        catch (ClientException e) {
            list = null;
        }
        if (list != null) {
            group.setParentGroups(list);
        }
        try {
            String label = (String)groupEntry.getProperty(this.groupSchemaName, this.groupLabelField);
            if (label != null) {
                group.setLabel(label);
            }
        }
        catch (ClientException e) {
            // empty catch block
        }
        return group;
    }

    public List<String> getTopLevelGroups() throws ClientException {
        return this.getTopLevelGroups(null);
    }

    public List<String> getGroupsInGroup(String parentId) throws ClientException {
        return this.getGroupsInGroup(parentId, null);
    }

    public List<String> getUsersInGroup(String groupId) throws ClientException {
        return this.getGroup(groupId).getMemberUsers();
    }

    public List<String> getUsersInGroupAndSubGroups(String groupId) throws ClientException {
        return this.getUsersInGroupAndSubGroups(groupId, null);
    }

    protected void appendSubgroups(String groupId, Set<String> groups, DocumentModel context) throws ClientException {
        List<String> groupsToAppend = this.getGroupsInGroup(groupId, context);
        groups.addAll(groupsToAppend);
        for (String subgroupId : groupsToAppend) {
            groups.add(subgroupId);
            if (groups.contains(subgroupId)) continue;
            this.appendSubgroups(subgroupId, groups, context);
        }
    }

    protected boolean isAnonymousMatching(Map<String, Serializable> filter, Set<String> fulltext) {
        String anonymousUserId = this.getAnonymousUserId();
        if (anonymousUserId == null) {
            return false;
        }
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        Map anonymousUserMap = this.anonymousUser.getProperties();
        anonymousUserMap.put(this.userIdField, anonymousUserId);
        for (Map.Entry<String, Serializable> e : filter.entrySet()) {
            String fieldName = e.getKey();
            Serializable expected = e.getValue();
            Object value = anonymousUserMap.get(fieldName);
            if (!(value == null ? expected != null : (fulltext != null && fulltext.contains(fieldName) ? !value.toString().toLowerCase().startsWith(expected.toString().toLowerCase()) : !value.equals(expected)))) continue;
            return false;
        }
        return true;
    }

    public List<NuxeoPrincipal> searchPrincipals(String pattern) throws ClientException {
        DocumentModelList entries = this.searchUsers(pattern);
        ArrayList<NuxeoPrincipal> principals = new ArrayList<NuxeoPrincipal>(entries.size());
        for (DocumentModel entry : entries) {
            principals.add(this.makePrincipal(entry));
        }
        return principals;
    }

    public DocumentModelList searchGroups(String pattern) throws ClientException {
        return this.searchGroups(pattern, null);
    }

    public String getUserSortField() {
        return this.userSortField;
    }

    protected Map<String, String> getUserSortMap() {
        return this.getDirectorySortMap(this.userSortField, this.userIdField);
    }

    protected Map<String, String> getGroupSortMap() {
        return this.getDirectorySortMap(this.groupSortField, this.groupIdField);
    }

    protected Map<String, String> getDirectorySortMap(String descriptorSortField, String fallBackField) {
        String sortField = descriptorSortField != null ? descriptorSortField : fallBackField;
        HashMap<String, String> orderBy = new HashMap<String, String>();
        orderBy.put(sortField, "asc");
        return orderBy;
    }

    protected void notify(String userOrGroupName, String eventId) throws ClientException {
        try {
            EventService eventService = (EventService)Framework.getService(EventService.class);
            eventService.sendEvent(new Event(USERMANAGER_TOPIC, eventId, (Object)this, (Object)userOrGroupName));
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void notifyUserChanged(String userName) throws ClientException {
        this.notify(userName, USERCHANGED_EVENT_ID);
    }

    protected void notifyGroupChanged(String groupName) throws ClientException {
        this.notify(groupName, GROUPCHANGED_EVENT_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean areGroupsReadOnly() throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            Boolean bl = groupDir.isReadOnly();
            return bl;
        }
        catch (DirectoryException e) {
            log.error((Object)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (groupDir != null) {
                    groupDir.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean areUsersReadOnly() throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            Boolean bl = userDir.isReadOnly();
            return bl;
        }
        catch (DirectoryException e) {
            log.error((Object)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (userDir != null) {
                    userDir.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected String getGroupId(DocumentModel groupModel) throws ClientException {
        Object groupIdValue = groupModel.getProperty(this.groupSchemaName, this.groupIdField);
        if (groupIdValue != null && !(groupIdValue instanceof String)) {
            throw new ClientException("Invalid group id " + groupIdValue);
        }
        return (String)groupIdValue;
    }

    protected String getUserId(DocumentModel userModel) throws ClientException {
        Object userIdValue = userModel.getProperty(this.userSchemaName, this.userIdField);
        if (userIdValue != null && !(userIdValue instanceof String)) {
            throw new ClientException("Invalid user id " + userIdValue);
        }
        return (String)userIdValue;
    }

    public DocumentModel createGroup(DocumentModel groupModel) throws ClientException {
        return this.createGroup(groupModel, null);
    }

    public DocumentModel createUser(DocumentModel userModel) throws ClientException {
        return this.createUser(userModel, null);
    }

    public void deleteGroup(String groupId) throws ClientException {
        this.deleteGroup(groupId, null);
    }

    public void deleteGroup(DocumentModel groupModel) throws ClientException {
        this.deleteGroup(groupModel, null);
    }

    public void deleteUser(String userId) throws ClientException {
        this.deleteUser(userId, null);
    }

    public void deleteUser(DocumentModel userModel) throws ClientException {
        String userId = this.getUserId(userModel);
        this.deleteUser(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupIds() throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName);
            List groupIds = groupDir.getProjection(Collections.emptyMap(), groupDir.getIdField());
            Collections.sort(groupIds);
            List list = groupIds;
            return list;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    public List<String> getUserIds() throws ClientException {
        return this.getUserIds(null);
    }

    protected void removeVirtualFilters(Map<String, Serializable> filter) {
        if (filter == null) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(filter.keySet());
        for (String key : keys) {
            if (!key.startsWith(VIRTUAL_FIELD_FILTER_PREFIX)) continue;
            filter.remove(key);
        }
    }

    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        return this.searchGroups(filter, fulltext, null);
    }

    public DocumentModelList searchUsers(String pattern) throws ClientException {
        return this.searchUsers(pattern, null);
    }

    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext) throws ClientException {
        return this.searchUsers(filter, fulltext, this.getUserSortMap(), null);
    }

    public void updateGroup(DocumentModel groupModel) throws ClientException {
        this.updateGroup(groupModel, null);
    }

    public void updateUser(DocumentModel userModel) throws ClientException {
        this.updateUser(userModel, null);
    }

    public DocumentModel getBareGroupModel() throws ClientException {
        String schema = this.dirService.getDirectorySchema(this.groupDirectoryName);
        return BaseSession.createEntryModel(null, (String)schema, null, null);
    }

    public void createGroup(NuxeoGroup group) throws ClientException {
        DocumentModel newGroupModel = this.getBareGroupModel();
        newGroupModel.setProperty(this.groupSchemaName, this.groupIdField, (Object)group.getName());
        newGroupModel.setProperty(this.groupSchemaName, this.groupMembersField, (Object)group.getMemberUsers());
        newGroupModel.setProperty(this.groupSchemaName, this.groupSubGroupsField, (Object)group.getMemberGroups());
        this.createGroup(newGroupModel);
    }

    public void createPrincipal(NuxeoPrincipal principal) throws ClientException {
        this.createUser(principal.getModel());
    }

    public void deleteGroup(NuxeoGroup group) throws ClientException {
        this.deleteGroup(group.getName());
    }

    public void deletePrincipal(NuxeoPrincipal principal) throws ClientException {
        this.deleteUser(principal.getName());
    }

    public List<NuxeoGroup> getAvailableGroups() throws ClientException {
        DocumentModelList groupModels = this.searchGroups(Collections.<String, Serializable>emptyMap(), null);
        ArrayList<NuxeoGroup> groups = new ArrayList<NuxeoGroup>(groupModels.size());
        for (DocumentModel groupModel : groupModels) {
            groups.add(this.makeGroup(groupModel));
        }
        return groups;
    }

    public List<NuxeoPrincipal> getAvailablePrincipals() throws ClientException {
        DocumentModelList userModels = this.searchUsers(Collections.<String, Serializable>emptyMap(), null);
        ArrayList<NuxeoPrincipal> users = new ArrayList<NuxeoPrincipal>(userModels.size());
        for (DocumentModel userModel : userModels) {
            users.add(this.makePrincipal(userModel));
        }
        return users;
    }

    public DocumentModel getModelForUser(String name) throws ClientException {
        return this.getUserModel(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NuxeoPrincipal> searchByMap(Map<String, Serializable> filter, Set<String> pattern) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName);
            this.removeVirtualFilters(filter);
            DocumentModelList entries = userDir.query(filter, pattern);
            ArrayList<NuxeoPrincipal> principals = new ArrayList<NuxeoPrincipal>(entries.size());
            for (DocumentModel entry : entries) {
                principals.add(this.makePrincipal(entry));
            }
            if (this.isAnonymousMatching(filter, pattern)) {
                principals.add(this.makeAnonymousPrincipal());
            }
            ArrayList<NuxeoPrincipal> arrayList = principals;
            return arrayList;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public void updateGroup(NuxeoGroup group) throws ClientException {
        DocumentModel newGroupModel = this.getGroupModel(group.getName());
        newGroupModel.setProperty(this.groupSchemaName, this.groupIdField, (Object)group.getName());
        newGroupModel.setProperty(this.groupSchemaName, this.groupMembersField, (Object)group.getMemberUsers());
        newGroupModel.setProperty(this.groupSchemaName, this.groupSubGroupsField, (Object)group.getMemberGroups());
        this.updateGroup(newGroupModel);
    }

    public void updatePrincipal(NuxeoPrincipal principal) throws ClientException {
        this.updateUser(principal.getModel());
    }

    public List<String> getAdministratorsGroups() {
        return this.administratorGroups;
    }

    protected List<String> getLeafPermissions(String perm) throws ClientException {
        PermissionProvider permissionProvider;
        ArrayList<String> permissions = new ArrayList<String>();
        try {
            permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        }
        catch (Exception e) {
            throw new Error("An unexpected error occured", e);
        }
        String[] subpermissions = permissionProvider.getSubPermissions(perm);
        if (subpermissions == null || subpermissions.length <= 0) {
            permissions.add(perm);
            return permissions;
        }
        for (String subperm : subpermissions) {
            permissions.addAll(this.getLeafPermissions(subperm));
        }
        return permissions;
    }

    public String[] getUsersForPermission(String perm, ACP acp) {
        return this.getUsersForPermission(perm, acp, null);
    }

    public Principal authenticate(String name, String password) throws ClientException {
        return this.checkUsernamePassword(name, password) ? this.getPrincipal(name) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, DocumentModel context) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName, context);
            this.removeVirtualFilters(filter);
            DocumentModelList entries = userDir.query(filter, fulltext, null, false);
            if (this.isAnonymousMatching(filter, fulltext)) {
                entries.add((Object)this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser));
            }
            if (orderBy != null && !orderBy.isEmpty()) {
                Collections.sort(entries, new DocumentModelComparator(this.userSchemaName, orderBy));
            }
            DocumentModelList documentModelList = entries;
            return documentModelList;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public List<String> getUsersInGroup(String groupId, DocumentModel context) throws ClientException {
        String storeGroupId = this.multiTenantManagement.groupnameTranformer(this, groupId, context);
        return this.getGroup(storeGroupId).getMemberUsers();
    }

    public DocumentModelList searchUsers(String pattern, DocumentModel context) throws ClientException {
        DocumentModelListImpl entries = new DocumentModelListImpl();
        if (pattern == null || pattern.length() == 0) {
            entries = this.searchUsers(Collections.<String, Serializable>emptyMap(), null);
        } else {
            HashMap<String, DocumentModel> uniqueEntries = new HashMap<String, DocumentModel>();
            for (Map.Entry<String, UserManager.MatchType> fieldEntry : this.userSearchFields.entrySet()) {
                HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
                filter.put(fieldEntry.getKey(), (Serializable)((Object)pattern));
                DocumentModelList fetchedEntries = fieldEntry.getValue() == UserManager.MatchType.SUBSTRING ? this.searchUsers(filter, filter.keySet(), null, context) : this.searchUsers(filter, null, null, context);
                for (DocumentModel entry : fetchedEntries) {
                    uniqueEntries.put(entry.getId(), entry);
                }
            }
            log.debug((Object)String.format("found %d unique entries", uniqueEntries.size()));
            entries.addAll(uniqueEntries.values());
        }
        Collections.sort(entries, new DocumentModelComparator(this.userSchemaName, this.getUserSortMap()));
        return entries;
    }

    public DocumentModelList searchUsers(Map<String, Serializable> filter, Set<String> fulltext, DocumentModel context) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public List<String> getGroupIds(DocumentModel context) throws ClientException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList searchGroups(Map<String, Serializable> filter, Set<String> fulltext, DocumentModel context) throws ClientException {
        filter = filter != null ? this.cloneMap(filter) : new HashMap();
        HashSet<String> fulltextClone = fulltext != null ? this.cloneSet(fulltext) : new HashSet<String>();
        this.multiTenantManagement.queryTransformer(this, filter, fulltextClone, context);
        Session groupDir = null;
        try {
            this.removeVirtualFilters(filter);
            groupDir = this.dirService.open(this.groupDirectoryName, context);
            DocumentModelList documentModelList = groupDir.query(filter, fulltextClone, this.getGroupSortMap(), false);
            return documentModelList;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel createGroup(DocumentModel groupModel, DocumentModel context) throws ClientException, GroupAlreadyExistsException {
        groupModel = this.multiTenantManagement.groupTransformer(this, groupModel, context);
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName, context);
            String groupId = this.getGroupId(groupModel);
            if (groupDir.hasEntry(groupId)) {
                throw new GroupAlreadyExistsException();
            }
            groupModel = groupDir.createEntry(groupModel);
            groupDir.commit();
            this.notifyGroupChanged(groupId);
            this.notify(groupId, GROUPCREATED_EVENT_ID);
            DocumentModel documentModel = groupModel;
            return documentModel;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel getGroupModel(String groupIdValue, DocumentModel context) throws ClientException {
        String groupName = this.multiTenantManagement.groupnameTranformer(this, groupIdValue, context);
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName, context);
            DocumentModel documentModel = groupDir.getEntry(groupName);
            return documentModel;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel getUserModel(String userName, DocumentModel context) throws ClientException {
        if (userName == null) {
            return null;
        }
        if (this.anonymousUser != null && userName.equals(this.anonymousUser.getId())) {
            return this.makeVirtualUserEntry(this.getAnonymousUserId(), this.anonymousUser);
        }
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName, context);
            DocumentModel documentModel = userDir.getEntry(userName);
            return documentModel;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    protected Map<String, Serializable> cloneMap(Map<String, Serializable> map) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        for (String key : map.keySet()) {
            result.put(key, map.get(key));
        }
        return result;
    }

    protected HashSet<String> cloneSet(Set<String> set) {
        HashSet<String> result = new HashSet<String>();
        for (String key : set) {
            result.add(key);
        }
        return result;
    }

    public NuxeoPrincipal getPrincipal(String username, DocumentModel context) throws ClientException {
        if (username == null) {
            return null;
        }
        String anonymousUserId = this.getAnonymousUserId();
        if (username.equals(anonymousUserId)) {
            return this.makeAnonymousPrincipal();
        }
        if (this.virtualUsers.containsKey(username)) {
            return this.makeVirtualPrincipal((VirtualUser)this.virtualUsers.get(username));
        }
        DocumentModel userModel = this.getUserModel(username, context);
        if (userModel != null) {
            return this.makePrincipal(userModel);
        }
        return null;
    }

    public DocumentModelList searchGroups(String pattern, DocumentModel context) throws ClientException {
        DocumentModelListImpl entries = new DocumentModelListImpl();
        if (pattern == null || pattern.length() == 0) {
            entries = this.searchGroups(Collections.<String, Serializable>emptyMap(), null);
        } else {
            HashMap<String, DocumentModel> uniqueEntries = new HashMap<String, DocumentModel>();
            for (Map.Entry<String, UserManager.MatchType> fieldEntry : this.groupSearchFields.entrySet()) {
                HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
                filter.put(fieldEntry.getKey(), (Serializable)((Object)pattern));
                DocumentModelList fetchedEntries = fieldEntry.getValue() == UserManager.MatchType.SUBSTRING ? this.searchGroups(filter, filter.keySet(), context) : this.searchGroups(filter, null, context);
                for (DocumentModel entry : fetchedEntries) {
                    uniqueEntries.put(entry.getId(), entry);
                }
            }
            log.debug((Object)String.format("found %d unique group entries", uniqueEntries.size()));
            entries.addAll(uniqueEntries.values());
        }
        Collections.sort(entries, new DocumentModelComparator(this.groupSchemaName, this.getGroupSortMap()));
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserIds(DocumentModel context) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName, context);
            List userIds = userDir.getProjection(Collections.emptyMap(), userDir.getIdField());
            Collections.sort(userIds);
            List list = userIds;
            return list;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel createUser(DocumentModel userModel, DocumentModel context) throws ClientException, UserAlreadyExistsException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName, context);
            String userId = this.getUserId(userModel);
            if (userDir.hasEntry(userId)) {
                throw new UserAlreadyExistsException();
            }
            String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
            String clearUsername = (String)userModel.getProperty(schema, userDir.getIdField());
            String clearPassword = (String)userModel.getProperty(schema, userDir.getPasswordField());
            userModel = userDir.createEntry(userModel);
            userDir.commit();
            this.syncDigestAuthPassword(clearUsername, clearPassword);
            this.notifyUserChanged(userId);
            this.notify(userId, USERCREATED_EVENT_ID);
            DocumentModel documentModel = userModel;
            return documentModel;
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(DocumentModel userModel, DocumentModel context) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName, context);
            String userId = this.getUserId(userModel);
            if (!userDir.hasEntry(userId)) {
                throw new DirectoryException("user does not exist: " + userId);
            }
            String schema = this.dirService.getDirectorySchema(this.userDirectoryName);
            String clearUsername = (String)userModel.getProperty(schema, userDir.getIdField());
            String clearPassword = (String)userModel.getProperty(schema, userDir.getPasswordField());
            userDir.updateEntry(userModel);
            userDir.commit();
            this.syncDigestAuthPassword(clearUsername, clearPassword);
            this.notifyUserChanged(userId);
            this.notify(userId, USERMODIFIED_EVENT_ID);
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    public void deleteUser(DocumentModel userModel, DocumentModel context) throws ClientException {
        String userId = this.getUserId(userModel);
        this.deleteUser(userId, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String userId, DocumentModel context) throws ClientException {
        Session userDir = null;
        try {
            userDir = this.dirService.open(this.userDirectoryName, context);
            if (!userDir.hasEntry(userId)) {
                throw new DirectoryException("User does not exist: " + userId);
            }
            userDir.deleteEntry(userId);
            userDir.commit();
            this.notifyUserChanged(userId);
            this.notify(userId, USERDELETED_EVENT_ID);
        }
        finally {
            if (userDir != null) {
                userDir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroup(DocumentModel groupModel, DocumentModel context) throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName, context);
            String groupId = this.getGroupId(groupModel);
            if (!groupDir.hasEntry(groupId)) {
                throw new DirectoryException("group does not exist: " + groupId);
            }
            groupDir.updateEntry(groupModel);
            groupDir.commit();
            this.notifyGroupChanged(groupId);
            this.notify(groupId, GROUPMODIFIED_EVENT_ID);
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    public void deleteGroup(DocumentModel groupModel, DocumentModel context) throws ClientException {
        String groupId = this.getGroupId(groupModel);
        this.deleteGroup(groupId, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGroup(String groupId, DocumentModel context) throws ClientException {
        Session groupDir = null;
        try {
            groupDir = this.dirService.open(this.groupDirectoryName, context);
            if (!groupDir.hasEntry(groupId)) {
                throw new DirectoryException("Group does not exist: " + groupId);
            }
            groupDir.deleteEntry(groupId);
            groupDir.commit();
            this.notifyGroupChanged(groupId);
            this.notify(groupId, GROUPDELETED_EVENT_ID);
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    public List<String> getGroupsInGroup(String parentId, DocumentModel context) throws ClientException {
        return this.getGroup(parentId, null).getMemberGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTopLevelGroups(DocumentModel context) throws ClientException {
        Session groupDir = null;
        try {
            LinkedList<String> topLevelGroups = new LinkedList<String>();
            groupDir = this.dirService.open(this.groupDirectoryName, context);
            DocumentModelList groups = groupDir.query(Collections.emptyMap(), null, null, true);
            for (DocumentModel group : groups) {
                List parents = (List)group.getProperty(this.groupSchemaName, this.groupParentGroupsField);
                if (parents != null && !parents.isEmpty()) continue;
                topLevelGroups.add(group.getId());
            }
            LinkedList<String> linkedList = topLevelGroups;
            return linkedList;
        }
        finally {
            if (groupDir != null) {
                groupDir.close();
            }
        }
    }

    public List<String> getUsersInGroupAndSubGroups(String groupId, DocumentModel context) throws ClientException {
        HashSet<String> groups = new HashSet<String>();
        groups.add(groupId);
        this.appendSubgroups(groupId, groups, context);
        HashSet users = new HashSet();
        for (String groupid : groups) {
            users.addAll(this.getGroup(groupid, context).getMemberUsers());
        }
        return new ArrayList<String>(users);
    }

    public String[] getUsersForPermission(String perm, ACP acp, DocumentModel context) {
        HashSet<String> usernames = new HashSet<String>();
        ACL merged = acp.getMergedACLs("merged");
        ArrayList<ACE> filteredACEbyPerm = new ArrayList<ACE>();
        List<String> currentPermissions = null;
        try {
            currentPermissions = this.getLeafPermissions(perm);
            for (ACE ace : merged.getACEs()) {
                List<String> acePermissions = this.getLeafPermissions(ace.getPermission());
                if ("Everything".equals(ace.getPermission())) {
                    try {
                        acePermissions = Arrays.asList(((PermissionProvider)Framework.getService(PermissionProvider.class)).getPermissions());
                    }
                    catch (Exception e) {
                        throw new Error("An unexpected error occured", e);
                    }
                }
                if (!acePermissions.containsAll(currentPermissions)) continue;
                if ("Everyone".equals(ace.getUsername()) && !ace.isGranted()) {
                    filteredACEbyPerm.clear();
                    continue;
                }
                filteredACEbyPerm.add(ace);
            }
        }
        catch (ClientException e2) {
            throw new Error("An unexpected error occured", e2);
        }
        for (ACE ace : filteredACEbyPerm) {
            try {
                NuxeoGroup group;
                String aceUsername = ace.getUsername();
                List<String> users = null;
                if ("Everyone".equals(aceUsername)) {
                    users = this.getUserIds();
                }
                if (users == null && (group = this.getGroup(aceUsername, context)) != null) {
                    users = this.getUsersInGroupAndSubGroups(aceUsername, context);
                }
                if (users == null) {
                    users = new ArrayList<String>();
                    users.add(aceUsername);
                }
                if (ace.isGranted()) {
                    usernames.addAll(users);
                    continue;
                }
                usernames.removeAll(users);
            }
            catch (ClientException e) {
                throw new Error("An unexpected error occured while getting user ids", e);
            }
        }
        return usernames.toArray(new String[usernames.size()]);
    }
}

