/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.api.operation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Operation(id="BulkRestartWorkflow", category="Workflow Context", label="BulkRestartWorkflow", description="Bulk operation to restart workflows.")
public class BulkRestartWorkflow {
    public static final String ID = "BulkRestartWorkflow";
    private static final Log log = LogFactory.getLog(BulkRestartWorkflow.class);
    @Context
    protected CoreSession session;
    @Param(name="workflowId", required=true)
    protected String workflowId;
    @Param(name="nodeId", required=false)
    protected String nodeId;
    @Param(name="reinitLifecycle", required=false)
    protected boolean reinitLifecycle;
    @Param(name="batchSize", required=false)
    protected Integer batchSize;
    public static final int DEFAULT_BATCH_SIZE = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public void run() throws ClientException {
        Split split = SimonManager.getStopwatch((String)ID).start();
        String query = "Select %s from DocumentRoute where (ecm:name like '%s.%%' OR  ecm:name like '%s') and ecm:currentLifeCycleState = 'running'";
        String key = "ecm:uuid";
        if (StringUtils.isEmpty((String)this.nodeId)) {
            if (StringUtils.isEmpty((String)this.workflowId)) {
                log.error((Object)"Need to specify either the workflowModelId either the nodeId to query the workflows");
                return;
            }
            query = String.format(query, key, this.workflowId, this.workflowId);
        } else {
            query = "Select %s from RouteNode  where rnode:nodeId = '%s' and ecm:currentLifeCycleState = 'suspended'";
            key = "ecm:parentId";
            if (StringUtils.isEmpty((String)this.nodeId)) {
                log.error((Object)"Need to specify either the workflowModelId either the nodeId to query the workflows");
                return;
            }
            query = String.format(query, key, this.nodeId);
        }
        IterableQueryResult results = this.session.queryAndFetch(query, "NXQL", new Object[0]);
        ArrayList<String> routeIds = new ArrayList<String>();
        for (Map result : results) {
            routeIds.add(((Serializable)result.get(key)).toString());
        }
        results.close();
        DocumentRoutingService routingService = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        if (this.batchSize == null) {
            this.batchSize = 1000;
        }
        boolean transactionStarted = false;
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
            transactionStarted = true;
        }
        try {
            long routesRestartedCount = 0L;
            for (String routeId : routeIds) {
                try {
                    DocumentModel docRoute = this.session.getDocument((DocumentRef)new IdRef(routeId));
                    DocumentRoute route = (DocumentRoute)docRoute.getAdapter(DocumentRoute.class);
                    List<String> relatedDocIds = route.getAttachedDocuments();
                    route.cancel(this.session);
                    log.debug((Object)("Canceling workflow  " + route.getDocument().getName()));
                    if (this.reinitLifecycle) {
                        this.reinitLifecycle(relatedDocIds, this.session);
                    }
                    routingService.createNewInstance(this.workflowId, relatedDocIds, this.session, true);
                    for (String string : relatedDocIds) {
                        log.debug((Object)("Starting workflow for " + string));
                    }
                    this.session.removeDocument(route.getDocument().getRef());
                    if (++routesRestartedCount % (long)this.batchSize.intValue() != 0L) continue;
                    TransactionHelper.commitOrRollbackTransaction();
                    TransactionHelper.startTransaction();
                }
                catch (Exception e) {
                    Throwable t = BulkRestartWorkflow.unwrapException(e);
                    log.error((Object)(t.getClass().getSimpleName() + ": " + t.getMessage()));
                    log.error((Object)("Workflow with the docId '" + routeId + "' cannot be canceled. " + routesRestartedCount + " workflows have been processed."));
                }
            }
        }
        finally {
            TransactionHelper.commitOrRollbackTransaction();
            if (!transactionStarted) {
                TransactionHelper.startTransaction();
            }
            split.stop();
            log.info((Object)split.toString());
        }
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t instanceof ClientException) {
            cause = t.getCause();
        } else if (t instanceof Exception) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return BulkRestartWorkflow.unwrapException(cause);
    }

    protected void reinitLifecycle(List<String> docIds, CoreSession session) throws ClientException {
        for (String docId : docIds) {
            session.reinitLifeCycleState((DocumentRef)new IdRef(docId));
        }
    }
}

