/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;
import com.sun.facelets.tag.jsf.ComponentHandler;
import com.sun.facelets.tag.ui.IncludeHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.TagConfigFactory;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class LayoutTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute name;
    protected final TagAttribute category;
    protected final TagAttribute definition;
    protected final TagAttribute mode;
    protected final TagAttribute value;
    protected final TagAttribute template;
    protected final TagAttribute selectedRows;
    protected final TagAttribute selectedColumns;
    protected final TagAttribute selectAllByDefault;
    protected final TagAttribute[] vars;
    protected final String[] reservedVarsArray = new String[]{"id", "name", "category", "definition", "mode", "value", "template", "selectedRows", "selectedColumns", "selectAllByDefault"};

    public LayoutTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.name = this.getAttribute("name");
        this.category = this.getAttribute("category");
        this.definition = this.getAttribute("definition");
        if (this.name == null && this.definition == null) {
            throw new TagException(this.tag, "At least one of attributes 'name', or 'definition' is required");
        }
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getRequiredAttribute("value");
        this.template = this.getAttribute("template");
        this.selectedRows = this.getAttribute("selectedRows");
        this.selectedColumns = this.getAttribute("selectedColumns");
        if (this.selectedRows != null && this.selectedColumns != null) {
            throw new TagException(this.tag, "Attributes 'selectedRows' and 'selectedColumns' are aliases: only one of them should be filled");
        }
        this.selectAllByDefault = this.getAttribute("selectAllByDefault");
        this.vars = this.tag.getAttributes().getAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        WebLayoutManager layoutService;
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        if (layoutService == null) {
            throw new FacesException("Layout service not found");
        }
        String modeValue = this.mode.getValue(ctx);
        String valueName = this.value.getValue();
        if (ComponentTagUtils.isStrictValueReference((String)valueName)) {
            valueName = ComponentTagUtils.getBareValueName((String)valueName);
        }
        List selectedRowsValue = null;
        if (this.selectedRows != null || this.selectedColumns != null) {
            if (this.selectedRows != null) {
                selectedRowsValue = (List)this.selectedRows.getObject(ctx, List.class);
            } else if (this.selectedColumns != null) {
                selectedRowsValue = (List)this.selectedColumns.getObject(ctx, List.class);
            }
        }
        boolean selectAllByDefaultValue = false;
        if (this.selectAllByDefault != null) {
            selectAllByDefaultValue = this.selectAllByDefault.getBoolean(ctx);
        }
        String templateValue = null;
        if (this.template != null) {
            templateValue = this.template.getValue(ctx);
        }
        HashMap<String, Serializable> additionalProps = new HashMap<String, Serializable>();
        List<String> reservedVars = Arrays.asList(this.reservedVarsArray);
        for (TagAttribute var : this.vars) {
            String localName = var.getLocalName();
            if (reservedVars.contains(localName)) continue;
            additionalProps.put(localName, (Serializable)((Object)var.getValue(ctx)));
        }
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapperWrapper vm = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        Map<String, ValueExpression> vars = this.getVariablesForLayoutBuild(ctx, modeValue);
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        try {
            for (Map.Entry<String, ValueExpression> var : vars.entrySet()) {
                vm.setVariable(var.getKey(), var.getValue());
            }
            if (this.name != null) {
                String layoutCategory = null;
                if (this.category != null) {
                    layoutCategory = this.category.getValue(ctx);
                }
                String nameValue = this.name.getValue(ctx);
                List<String> layoutNames = this.resolveLayoutNames(nameValue);
                for (String layoutName : layoutNames) {
                    Layout layoutInstance = layoutService.getLayout(ctx, layoutName, layoutCategory, modeValue, valueName, selectedRowsValue, selectAllByDefaultValue);
                    if (layoutInstance == null) {
                        String errMsg = String.format("Layout '%s' not found", layoutName);
                        this.applyErrorHandler(ctx, parent, helper, errMsg);
                        continue;
                    }
                    this.applyLayoutHandler(ctx, parent, helper, layoutService, layoutInstance, templateValue, additionalProps, vars);
                }
            }
            if (this.definition != null) {
                LayoutDefinition layoutDef = (LayoutDefinition)this.definition.getObject(ctx, LayoutDefinition.class);
                if (layoutDef == null) {
                    String errMsg = "Layout definition resolved to null";
                    this.applyErrorHandler(ctx, parent, helper, errMsg);
                } else {
                    Layout layoutInstance = layoutService.getLayout(ctx, layoutDef, modeValue, valueName, (List<String>)selectedRowsValue, selectAllByDefaultValue);
                    this.applyLayoutHandler(ctx, parent, helper, layoutService, layoutInstance, templateValue, additionalProps, vars);
                }
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    protected List<String> resolveLayoutNames(String nameValue) {
        ArrayList<String> res = new ArrayList<String>();
        if (nameValue != null && nameValue.contains(",")) {
            String[] names;
            for (String layoutName : names = nameValue.split(",")) {
                if (StringUtils.isBlank((String)layoutName)) continue;
                layoutName = layoutName.trim();
                res.add(layoutName);
            }
        } else {
            nameValue = nameValue == null ? "" : nameValue.trim();
            res.add(nameValue);
        }
        return res;
    }

    protected void applyLayoutHandler(FaceletContext ctx, UIComponent parent, FaceletHandlerHelper helper, WebLayoutManager layoutService, Layout layoutInstance, String templateValue, Map<String, Serializable> additionalProps, Map<String, ValueExpression> vars) throws IOException, FacesException, ELException {
        layoutInstance.setId(helper.generateLayoutId(layoutInstance.getName()));
        Map layoutProps = layoutInstance.getProperties();
        if (additionalProps != null && !additionalProps.isEmpty()) {
            for (Map.Entry<String, Serializable> entry : additionalProps.entrySet()) {
                String key = entry.getKey();
                Serializable value = entry.getValue();
                if (layoutProps.containsKey(key) && (value == null || value instanceof String && StringUtils.isBlank((String)((String)((Object)value))))) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Do not override property '%s' with empty value on layout named '%s'", key, layoutInstance.getName()));
                    continue;
                }
                layoutInstance.setProperty(key, value);
            }
        }
        if (StringUtils.isBlank((String)templateValue)) {
            templateValue = layoutInstance.getTemplate();
        }
        if (!StringUtils.isBlank((String)templateValue)) {
            String layoutTagConfigId = layoutInstance.getTagConfigId();
            TagAttribute srcAttr = helper.createAttribute("src", templateValue);
            TagConfig config = TagConfigFactory.createTagConfig(this.config, layoutTagConfigId, FaceletHandlerHelper.getTagAttributes(srcAttr), this.nextHandler);
            IncludeHandler includeHandler = new IncludeHandler(config);
            ExpressionFactory eFactory = ctx.getExpressionFactory();
            ValueExpression layoutVe = eFactory.createValueExpression((Object)layoutInstance, Layout.class);
            ctx.getVariableMapper().setVariable(RenderVariables.layoutVariables.layout.name(), layoutVe);
            vars.putAll(this.getVariablesForLayoutRendering(ctx, layoutService, layoutInstance));
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.layoutVariables.layout.name());
            blockedPatterns.add(RenderVariables.layoutVariables.layoutProperty.name() + "_*");
            FaceletHandler handler = helper.getAliasTagHandler(layoutTagConfigId, vars, blockedPatterns, (FaceletHandler)includeHandler);
            handler.apply(ctx, parent);
        } else {
            String errMsg = String.format("Missing template property for layout '%s'", layoutInstance.getName());
            this.applyErrorHandler(ctx, parent, helper, errMsg);
        }
    }

    protected Map<String, ValueExpression> getVariablesForLayoutBuild(FaceletContext ctx, String modeValue) {
        HashMap<String, ValueExpression> vars = new HashMap<String, ValueExpression>();
        ValueExpression valueExpr = this.value.getValueExpression(ctx, Object.class);
        vars.put(RenderVariables.globalVariables.value.name(), valueExpr);
        vars.put(RenderVariables.globalVariables.document.name(), valueExpr);
        vars.put(RenderVariables.globalVariables.layoutValue.name(), valueExpr);
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression modeVe = eFactory.createValueExpression((Object)modeValue, String.class);
        vars.put(RenderVariables.globalVariables.layoutMode.name(), modeVe);
        vars.put(RenderVariables.globalVariables.mode.name(), modeVe);
        return vars;
    }

    protected Map<String, ValueExpression> getVariablesForLayoutRendering(FaceletContext ctx, WebLayoutManager layoutService, Layout layoutInstance) {
        HashMap<String, ValueExpression> vars = new HashMap<String, ValueExpression>();
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression layoutVe = eFactory.createValueExpression((Object)layoutInstance, Layout.class);
        vars.put(RenderVariables.layoutVariables.layout.name(), layoutVe);
        for (Map.Entry prop : layoutInstance.getProperties().entrySet()) {
            String key = (String)prop.getKey();
            String name = String.format("%s_%s", RenderVariables.layoutVariables.layoutProperty.name(), key);
            Serializable valueInstance = (Serializable)prop.getValue();
            String value = !layoutService.referencePropertyAsExpression(key, valueInstance, null, null, null) ? (String)((Object)valueInstance) : String.format("#{%s.properties.%s}", RenderVariables.layoutVariables.layout.name(), key);
            vars.put(name, eFactory.createValueExpression((ELContext)ctx, value, Object.class));
        }
        return vars;
    }

    protected void applyErrorHandler(FaceletContext ctx, UIComponent parent, FaceletHandlerHelper helper, String message) throws IOException {
        log.error((Object)message);
        ComponentHandler output = helper.getErrorComponentHandler(null, message);
        output.apply(ctx, parent);
    }
}

