/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;
import org.nuxeo.runtime.api.Framework;

public class DefaultFileImporter
extends AbstractFileImporter {
    public static final String TYPE_NAME = "File";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DefaultFileImporter.class);

    public static String getTypeName(DocumentModel currentDoc) {
        String defaultType;
        UITypesConfiguration configuration = DefaultFileImporter.getConfiguration(currentDoc);
        if (configuration != null && (defaultType = configuration.getDefaultType()) != null) {
            return defaultType;
        }
        return TYPE_NAME;
    }

    @Override
    public DocumentModel create(CoreSession documentManager, Blob input, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        path = this.getNearestContainerPath(documentManager, path);
        PathRef containerRef = new PathRef(path);
        DocumentModel container = documentManager.getDocument((DocumentRef)containerRef);
        String typeName = DefaultFileImporter.getTypeName(container);
        this.doSecurityCheck(documentManager, path, typeName, typeService);
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        input.setFilename(filename);
        DocumentModel docModel = FileManagerUtils.getExistingDocByFileName((CoreSession)documentManager, (String)path, (String)filename);
        if (overwrite && docModel != null) {
            docModel = this.overwriteAndIncrementversion(documentManager, docModel);
            docModel.setPropertyValue("file:content", (Serializable)input.persist());
            documentManager.saveDocument(docModel);
        } else {
            PathSegmentService pss;
            String title = FileManagerUtils.fetchTitle((String)filename);
            try {
                pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            docModel = documentManager.createDocumentModel(typeName);
            docModel.setProperty("dublincore", "title", (Object)title);
            docModel.setProperty("file", "filename", (Object)filename);
            docModel.setProperty("file", "content", (Object)input);
            docModel.setPathInfo(path, pss.generatePathSegment(docModel));
            docModel = documentManager.createDocument(docModel);
        }
        documentManager.save();
        log.debug((Object)("imported the document: " + docModel.getName() + " with icon: " + docModel.getProperty("common", "icon") + " and type: " + typeName));
        return docModel;
    }

    protected static UITypesConfiguration getConfiguration(DocumentModel currentDoc) {
        UITypesConfiguration configuration = null;
        try {
            LocalConfigurationService localConfigurationService = (LocalConfigurationService)Framework.getService(LocalConfigurationService.class);
            configuration = (UITypesConfiguration)localConfigurationService.getConfiguration(UITypesConfiguration.class, "UITypesLocalConfiguration", currentDoc);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return configuration;
    }
}

