/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class NoteImporter
extends AbstractFileImporter {
    private static final String ICON_FIELD = "icon";
    private static final String COMMON_SCHEMA = "common";
    private static final String NOTE_FIELD = "note";
    private static final String MT_FIELD = "mime_type";
    private static final String NOTE_SCHEMA = "note";
    private static final String TITLE_FIELD = "title";
    private static final String DUBLINCORE_SCHEMA = "dublincore";
    private static final String NOTE_TYPE = "Note";
    private static final long serialVersionUID = 1073550562485540108L;
    private static final Log log = LogFactory.getLog(NoteImporter.class);

    protected String getNoteTypeName() {
        return NOTE_TYPE;
    }

    @Override
    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        path = this.getNearestContainerPath(documentManager, path);
        this.doSecurityCheck(documentManager, path, this.getNoteTypeName(), typeService);
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        String title = FileManagerUtils.fetchTitle((String)filename);
        DocumentModel docModel = FileManagerUtils.getExistingDocByTitle((CoreSession)documentManager, (String)path, (String)title);
        if (overwrite && docModel != null) {
            docModel.setProperty("note", "note", (Object)this.getString(content));
            docModel.setProperty("note", MT_FIELD, (Object)content.getMimeType());
            docModel = this.overwriteAndIncrementversion(documentManager, docModel);
        } else {
            PathSegmentService pss;
            try {
                pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            docModel = documentManager.createDocumentModel(this.getNoteTypeName());
            docModel.setProperty(DUBLINCORE_SCHEMA, TITLE_FIELD, (Object)title);
            docModel.setProperty("note", "note", (Object)this.getString(content));
            docModel.setProperty("note", MT_FIELD, (Object)content.getMimeType());
            docModel.setPathInfo(path, pss.generatePathSegment(docModel));
            docModel = documentManager.createDocument(docModel);
        }
        documentManager.save();
        log.debug((Object)("Created the Note: " + docModel.getName() + " with icon: " + docModel.getProperty(COMMON_SCHEMA, ICON_FIELD)));
        return docModel;
    }

    protected String getString(Blob blob) throws IOException {
        String s = NoteImporter.guessEncoding(blob);
        if (s == null) {
            s = blob.getString();
        }
        return s;
    }

    protected static String guessEncoding(Blob blob) throws IOException {
        if (blob.getEncoding() != null) {
            return null;
        }
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            return null;
        }
        if (!mimeType.startsWith("text/") && !mimeType.startsWith("application/xhtml")) {
            return null;
        }
        byte[] bytes = blob.getByteArray();
        List<String> charsets = Arrays.asList("utf-8", "iso-8859-1");
        String CSEQ = "charset=";
        int i = mimeType.indexOf(CSEQ);
        if (i > 0) {
            String onlyMimeType = mimeType.substring(0, i).replace(";", "").trim();
            blob.setMimeType(onlyMimeType);
            String charset = mimeType.substring(i + CSEQ.length());
            i = charset.indexOf(";");
            if (i > 0) {
                charset = charset.substring(0, i);
            }
            charset = charset.trim().replace("\"", "");
            charsets = new ArrayList<String>(charsets);
            charsets.add(0, charset);
        }
        for (String charset : charsets) {
            try {
                Charset cs = Charset.forName(charset);
                CharsetDecoder d = cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                CharBuffer cb = d.decode(ByteBuffer.wrap(bytes));
                return cb.toString();
            }
            catch (IllegalArgumentException e) {
            }
            catch (CharacterCodingException e) {
            }
        }
        return null;
    }
}

