/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.xplain.HighLevelXplain;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedCNFReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    private int numberOfComponents;
    private final HighLevelXplain<ISolver> hlxplain;
    private int currentComponentIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.reader.GroupedCNFReader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GroupedCNFReader(HighLevelXplain<ISolver> solver) {
        super(solver, "gcnf");
        this.hlxplain = solver;
    }

    @Override
    protected void readProblemLine() throws IOException, ParseFormatException {
        String line = this.scanner.nextLine().trim();
        if (line == null) {
            throw new ParseFormatException(new StringBuffer("premature end of file: <p ").append(this.formatString).append(" ...> expected").toString());
        }
        String[] tokens = line.split("\\s+");
        if (tokens.length < 5 || !"p".equals(tokens[0]) || !this.formatString.equals(tokens[1])) {
            throw new ParseFormatException(new StringBuffer("problem line expected (p ").append(this.formatString).append(" ...)").toString());
        }
        int vars = Integer.parseInt(tokens[2]);
        if (!$assertionsDisabled && vars <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(vars);
        this.expectedNbOfConstr = Integer.parseInt(tokens[3]);
        if (!$assertionsDisabled && this.expectedNbOfConstr <= 0) {
            throw new AssertionError();
        }
        this.numberOfComponents = Integer.parseInt(tokens[4]);
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean handleLine() throws ContradictionException, IOException, ParseFormatException {
        added = false;
        component = this.scanner.next();
        if (!component.startsWith("{") || !component.endsWith("}")) {
            throw new ParseFormatException("Component index required at the beginning of the clause");
        }
        this.currentComponentIndex = Integer.valueOf(component.substring(1, component.length() - 1));
        if (this.currentComponentIndex >= 0 && this.currentComponentIndex <= this.numberOfComponents) ** GOTO lbl17
        throw new ParseFormatException(new StringBuffer("wrong component index: ").append(this.currentComponentIndex).toString());
lbl-1000:
        // 1 sources

        {
            lit = this.scanner.nextInt();
            if (lit == 0) {
                if (this.literals.size() <= 0) break;
                this.flushConstraint();
                this.literals.clear();
                added = true;
                break;
            }
            this.literals.push(lit);
lbl17:
            // 2 sources

            ** while (!this.scanner.eof())
        }
lbl18:
        // 3 sources

        return added;
    }

    @Override
    protected void flushConstraint() throws ContradictionException {
        block4: {
            try {
                if (this.currentComponentIndex == 0) {
                    this.hlxplain.addClause(this.literals);
                } else {
                    this.hlxplain.addClause(this.literals, this.currentComponentIndex);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!this.isVerbose()) break block4;
                System.err.println(new StringBuffer("c Skipping constraint ").append(this.literals).toString());
            }
        }
    }
}

