/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.HttpClientCall;
import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.http.StreamClientHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.data.Status;

public class StreamClientCall
extends HttpClientCall {
    private Request request;
    private OutputStream requestStream;
    private InputStream responseStream;

    public StreamClientCall(StreamClientHelper helper, Request request) {
        super(helper, request.getMethod().toString(), request.getResourceRef().getIdentifier());
        this.setVersion("HTTP/1.1");
    }

    public Socket createSocket(String hostDomain, int hostPort) throws UnknownHostException, IOException {
        return new Socket(hostDomain, hostPort);
    }

    public Request getRequest() {
        return this.request;
    }

    public WritableByteChannel getRequestChannel() {
        return null;
    }

    public OutputStream getRequestStream() {
        return this.requestStream;
    }

    public ReadableByteChannel getResponseChannel() {
        return null;
    }

    public InputStream getResponseStream() {
        return this.responseStream;
    }

    protected void parseResponse() throws IOException {
        StringBuilder sb = new StringBuilder();
        int next = this.getResponseStream().read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getResponseStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the response HTTP version. End of stream reached too early.");
        }
        this.setVersion(sb.toString());
        sb.delete(0, sb.length());
        next = this.getResponseStream().read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = this.getResponseStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the response status. End of stream reached too early.");
        }
        this.setStatusCode(Integer.parseInt(sb.toString()));
        sb.delete(0, sb.length());
        next = this.getResponseStream().read();
        while (next != -1 && !HttpUtils.isCarriageReturn(next)) {
            sb.append((char)next);
            next = this.getResponseStream().read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the reason phrase. End of stream reached too early.");
        }
        next = this.getResponseStream().read();
        if (HttpUtils.isLineFeed(next)) {
            this.setReasonPhrase(sb.toString());
            sb.delete(0, sb.length());
            Parameter header = HttpUtils.readHeader(this.getResponseStream(), sb);
            while (header != null) {
                this.getResponseHeaders().add(header);
                header = HttpUtils.readHeader(this.getResponseStream(), sb);
            }
        } else {
            throw new IOException("Unable to parse the reason phrase. The carriage return must be followed by a line feed.");
        }
    }

    public Status sendRequest(Request request) {
        Status result = null;
        try {
            String hostDomain = request.getResourceRef().getHostDomain();
            int hostPort = request.getResourceRef().getHostPort();
            if (hostPort == -1) {
                hostPort = request.getResourceRef().getSchemeProtocol().getDefaultPort();
            }
            Socket socket = this.createSocket(hostDomain, hostPort);
            this.requestStream = socket.getOutputStream();
            this.responseStream = socket.getInputStream();
            this.getRequestStream().write(this.getMethod().getBytes());
            this.getRequestStream().write(32);
            this.getRequestStream().write(this.getRequestUri().getBytes());
            this.getRequestStream().write(32);
            this.getRequestStream().write(this.getVersion().getBytes());
            this.getRequestStream().write(13);
            this.getRequestStream().write(10);
            this.getRequestHeaders().set("Connection", "close", true);
            String host = hostDomain;
            if (request.getResourceRef().getHostPort() != -1) {
                host = host + ":" + request.getResourceRef().getHostPort();
            }
            this.getRequestHeaders().set("Host", host, true);
            for (Parameter header : this.getRequestHeaders()) {
                HttpUtils.writeHeader(header, this.getRequestStream());
            }
            this.getRequestStream().write(13);
            this.getRequestStream().write(10);
            result = super.sendRequest(request);
            this.parseResponse();
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.WARNING, "An error occured during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, "Unable to complete the HTTP call due to a communication error with the remote server. " + ioe.getMessage());
        }
        return result;
    }
}

