/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.webcontainer;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.webapp.webcontainer.ThemeActions;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.NegotiationDef;
import org.nuxeo.theme.negotiation.Negotiator;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.Flavor;
import org.nuxeo.theme.styling.service.descriptors.Logo;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;

@Name(value="themeActions")
@Scope(value=ScopeType.PAGE)
public class ThemeActionsBean
implements ThemeActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ThemeActionsBean.class);

    @Override
    public String getDefaultTheme() {
        FacesContext faces = FacesContext.getCurrentInstance();
        return this.getDefaultTheme(faces.getExternalContext());
    }

    protected String getDefaultTheme(ExternalContext ec) {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ApplicationType app = (ApplicationType)typeRegistry.lookup(TypeFamily.APPLICATION, ec.getRequestContextPath());
        NegotiationDef negotiation = app.getNegotiation();
        return negotiation.getDefaultTheme();
    }

    @Override
    public Logo getLogo() {
        FacesContext faces = FacesContext.getCurrentInstance();
        ExternalContext ec = faces.getExternalContext();
        String flavor = (String)ec.getRequestMap().get("org.nuxeo.theme.negotiation.result." + Negotiator.NEGOTIATION_OBJECT.collection.name());
        return this.getLogo(flavor);
    }

    @Override
    public Logo getLogo(String flavorName) {
        if (flavorName == null) {
            return null;
        }
        ThemeStylingService service = this.getStylingService();
        if (service == null) {
            return null;
        }
        return service.getLogo(flavorName);
    }

    @Override
    public Flavor getFlavor(String flavorName) {
        if (flavorName == null) {
            return null;
        }
        ThemeStylingService service = this.getStylingService();
        if (service == null) {
            return null;
        }
        return service.getFlavor(flavorName);
    }

    protected ThemeStylingService getStylingService() {
        try {
            ThemeStylingService service = (ThemeStylingService)Framework.getService(ThemeStylingService.class);
            if (service == null) {
                log.error((Object)"Missing ThemeStylingService");
                return null;
            }
            return service;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }
}

