/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.schema;

import java.beans.IntrospectionException;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.IntrospectionConfiguration;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.schema.Schema;
import org.apache.commons.betwixt.schema.TranscriptionConfiguration;

public class SchemaTranscriber {
    public static final String W3C_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_SCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private XMLIntrospector introspector = new XMLIntrospector();
    private TranscriptionConfiguration configuration = new TranscriptionConfiguration();

    public TranscriptionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TranscriptionConfiguration configuration) {
        this.configuration = configuration;
    }

    public XMLIntrospector getXMLIntrospector() {
        return this.introspector;
    }

    public void setXMLIntrospector(XMLIntrospector introspector) {
        this.introspector = introspector;
    }

    public Schema generate(Class clazz) throws IntrospectionException {
        XMLBeanInfo beanInfo = this.introspector.introspect(clazz);
        return this.generate(beanInfo);
    }

    public Schema generate(XMLBeanInfo xmlBeanInfo) throws IntrospectionException {
        ElementDescriptor elementDescriptor = xmlBeanInfo.getElementDescriptor();
        Schema schema = new Schema(this.introspector);
        schema.addGlobalElementType(this.configuration, elementDescriptor);
        return schema;
    }

    public IntrospectionConfiguration createSchemaIntrospectionConfiguration() {
        IntrospectionConfiguration configuration = new IntrospectionConfiguration();
        configuration.getPrefixMapper().setPrefix(W3C_SCHEMA_URI, "xsd");
        configuration.getPrefixMapper().setPrefix(W3C_SCHEMA_INSTANCE_URI, "xsi");
        return configuration;
    }

    public BindingConfiguration createSchemaBindingConfiguration() {
        BindingConfiguration configuration = new BindingConfiguration();
        configuration.setMapIDs(false);
        return configuration;
    }
}

