/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class ConcatEval
implements OperationEval {
    private ConcatPtg delegate;

    public ConcatEval(ConcatPtg ptg) {
        this.delegate = ptg;
    }

    public Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < 2; ++i) {
                ValueEval ve = OperandResolver.getSingleValue(args[i], srcRow, srcCol);
                if (ve instanceof StringValueEval) {
                    StringValueEval sve = (StringValueEval)ve;
                    sb.append(sve.getStringValue());
                    continue;
                }
                if (ve == BlankEval.INSTANCE) continue;
                throw new RuntimeException("Unexpected value type (" + ve.getClass().getName() + ")");
            }
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new StringEval(sb.toString());
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }
}

