/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types.adapter;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.DocumentContentViews;
import org.nuxeo.ecm.platform.types.SubType;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.TypeView;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.runtime.api.Framework;

public class TypeInfoAdapter
implements TypeInfo {
    private final Type type;

    public TypeInfoAdapter(DocumentModel doc) {
        try {
            TypeManager mgr = (TypeManager)Framework.getService(TypeManager.class);
            this.type = mgr.getType(doc.getType());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get document type", e);
        }
    }

    public String[] getActions() {
        if (this.type != null) {
            return this.type.getActions();
        }
        return null;
    }

    @Override
    public Map<String, SubType> getAllowedSubTypes() {
        if (this.type != null) {
            return this.type.getAllowedSubTypes();
        }
        return null;
    }

    @Deprecated
    public String getCoreType() {
        if (this.type != null) {
            return this.type.getId();
        }
        return null;
    }

    @Override
    public String getCreateView() {
        if (this.type != null) {
            return this.type.getCreateView();
        }
        return null;
    }

    @Override
    public String getDefaultView() {
        if (this.type != null) {
            return this.type.getDefaultView();
        }
        return null;
    }

    @Override
    public String getEditView() {
        if (this.type != null) {
            return this.type.getEditView();
        }
        return null;
    }

    @Override
    public String getIcon() {
        if (this.type != null) {
            return this.type.getIcon();
        }
        return null;
    }

    @Override
    public String getIconExpanded() {
        if (this.type != null) {
            return this.type.getIconExpanded();
        }
        return null;
    }

    @Override
    public String getBigIcon() {
        if (this.type != null) {
            return this.type.getBigIcon();
        }
        return null;
    }

    @Override
    public String getBigIconExpanded() {
        if (this.type != null) {
            return this.type.getBigIconExpanded();
        }
        return null;
    }

    @Override
    public String getId() {
        if (this.type != null) {
            return this.type.getId();
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.type != null) {
            return this.type.getLabel();
        }
        return null;
    }

    @Override
    public String[] getLayouts(String mode) {
        if (this.type != null) {
            return this.type.getLayouts(mode);
        }
        return null;
    }

    @Override
    public String[] getLayouts(String mode, String defaultMode) {
        if (this.type != null) {
            return this.type.getLayouts(mode, defaultMode);
        }
        return null;
    }

    @Override
    public String getView(String viewId) {
        TypeView view;
        if (this.type != null && (view = this.type.getView(viewId)) != null) {
            return view.getValue();
        }
        return null;
    }

    @Override
    public TypeView[] getViews() {
        if (this.type != null) {
            return this.type.getViews();
        }
        return null;
    }

    @Override
    public String[] getContentViews(String category) {
        if (this.type != null) {
            return this.type.getContentViews(category);
        }
        return null;
    }

    @Override
    public Map<String, String[]> getContentViews() {
        if (this.type != null) {
            LinkedHashMap<String, String[]> res = new LinkedHashMap<String, String[]>();
            Map<String, DocumentContentViews> defs = this.type.getContentViews();
            if (defs != null) {
                for (Map.Entry<String, DocumentContentViews> def : defs.entrySet()) {
                    res.put(def.getKey(), def.getValue().getContentViewNames());
                }
            }
            return res;
        }
        return null;
    }

    @Override
    public Map<String, String[]> getContentViewsForExport() {
        if (this.type != null) {
            LinkedHashMap<String, String[]> res = new LinkedHashMap<String, String[]>();
            Map<String, DocumentContentViews> defs = this.type.getContentViews();
            if (defs != null) {
                for (Map.Entry<String, DocumentContentViews> def : defs.entrySet()) {
                    String[] cvsByCat = def.getValue().getContentViewNamesForExport();
                    if (cvsByCat == null || cvsByCat.length <= 0) continue;
                    res.put(def.getKey(), cvsByCat);
                }
            }
            return res;
        }
        return null;
    }
}

