/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.importer.core;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.platform.importer.properties.MetadataCollector;
import org.nuxeo.ecm.platform.importer.source.FileWithMetadataSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

class TargetContainerCreator
extends UnrestrictedSessionRunner {
    public static final String DEFAULT_IMPORT_FOLDER_TITLE = "Automatic Import";
    private static final Log log = LogFactory.getLog(TargetContainerCreator.class);
    public DocumentModel targetContainer;
    protected String importFolderPath;
    protected String importFolderTitle;
    protected String importSetTitle;
    protected String importWritePath;
    protected SourceNode importSource;

    public TargetContainerCreator(String repositoryName, String importFolderPath, String importFolderTitle, String importSetTitle, String importWritePath, SourceNode importSource) {
        super(repositoryName);
        this.importFolderPath = importFolderPath;
        this.importFolderTitle = importFolderTitle;
        this.importSetTitle = importSetTitle;
        this.importWritePath = importWritePath;
        this.importSource = importSource;
    }

    public void run() throws ClientException {
        try {
            DocumentModel importFolder = this.getOrCreateImportFolder();
            this.targetContainer = this.createImportSet(importFolder);
            this.session.save();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected DocumentModel getOrCreateImportFolder() throws ClientException {
        String importFolderName;
        PathRef importFolderRef;
        if (this.importFolderPath != null && this.importFolderPath.trim().length() > 0) {
            importFolderRef = new PathRef(this.importFolderPath);
            Path p = new Path(this.importFolderPath);
            importFolderName = p.segment(p.segmentCount() - 1);
        } else {
            if (this.importFolderTitle == null || this.importFolderTitle.trim().length() == 0) {
                this.importFolderTitle = DEFAULT_IMPORT_FOLDER_TITLE;
            }
            importFolderName = IdUtils.generateId((String)this.importFolderTitle);
            importFolderRef = new PathRef(this.importWritePath, importFolderName);
        }
        return this.getOrCreateImportFolder((DocumentRef)importFolderRef, importFolderName);
    }

    protected DocumentModel getOrCreateImportFolder(DocumentRef importFolderRef, String importFolderName) throws ClientException {
        DocumentModel importFolder;
        if (!this.session.exists(importFolderRef)) {
            importFolder = this.session.createDocumentModel(this.importWritePath, importFolderName, "ImportFolder");
            importFolder.setPropertyValue("dc:title", (Serializable)((Object)this.importFolderTitle));
            importFolder = this.session.createDocument(importFolder);
        } else {
            importFolder = this.session.getDocument(importFolderRef);
        }
        return importFolder;
    }

    protected DocumentModel createImportSet(DocumentModel importFolder) throws Exception {
        String title = this.importSetTitle != null && this.importSetTitle.trim().length() != 0 ? this.importSetTitle : this.generateImportSetName();
        DocumentModel importSet = this.session.createDocumentModel(importFolder.getPathAsString(), IdUtils.generateId((String)title), "ImportSet");
        importSet.setPropertyValue("dc:title", (Serializable)((Object)title));
        importSet = this.setImportSetProperties(importSet);
        importSet = this.session.createDocument(importSet);
        return importSet;
    }

    protected String generateImportSetName() {
        Calendar calendar = Calendar.getInstance();
        return new SimpleDateFormat("yyyyMMdd HH:mm").format(calendar.getTime());
    }

    protected DocumentModel setImportSetProperties(DocumentModel importSet) throws Exception {
        String sourcePath = this.importSource.getSourcePath();
        String metadataFilePath = sourcePath.endsWith(File.separator) ? sourcePath : sourcePath + File.separator;
        File metadataFile = new File(metadataFilePath = metadataFilePath + FileWithMetadataSourceNode.METADATA_FILENAME);
        if (metadataFile.exists()) {
            MetadataCollector metadataCollector = new MetadataCollector();
            metadataCollector.addPropertyFile(metadataFile);
            String contextPath = metadataFile.getAbsoluteFile().getParent();
            for (Map.Entry entry : metadataCollector.getProperties(contextPath).entrySet()) {
                try {
                    importSet.setPropertyValue((String)entry.getKey(), (Serializable)entry.getValue());
                }
                catch (PropertyNotFoundException e) {
                    String message = String.format("Property '%s' not found on document type: %s. Skipping it.", entry.getKey(), importSet.getType());
                    log.debug((Object)message);
                }
            }
        }
        return importSet;
    }
}

