/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.platform.importer.filter.ImporterFilter;
import org.nuxeo.runtime.api.Framework;

public class EventServiceConfiguratorFilter
implements ImporterFilter {
    private static final Log log = LogFactory.getLog(EventServiceConfiguratorFilter.class);
    protected boolean blockSyncPostCommitProcessing = false;
    protected boolean blockAsyncProcessing = false;
    protected boolean blockMimeTypeDetection = false;
    protected boolean blockNotifications = true;
    protected boolean bulkMode = false;
    protected EventServiceAdmin eventAdmin = null;
    protected static final String NOTIF_LISTENER = "notificationListener";
    protected static final String MIME_LISTENER = "mimetypeIconUpdater";

    public EventServiceConfiguratorFilter(Boolean blockSyncPostCommitProcessing, Boolean blockAsyncProcessing, Boolean blockMimeTypeDetection, Boolean bulkMode) {
        if (blockAsyncProcessing != null) {
            this.blockAsyncProcessing = blockAsyncProcessing;
        }
        if (blockSyncPostCommitProcessing != null) {
            this.blockSyncPostCommitProcessing = blockSyncPostCommitProcessing;
        }
        if (blockMimeTypeDetection != null) {
            this.blockMimeTypeDetection = blockMimeTypeDetection;
        }
        if (bulkMode != null) {
            this.bulkMode = bulkMode;
        }
    }

    @Override
    public void handleBeforeImport() {
        this.eventAdmin = (EventServiceAdmin)Framework.getLocalService(EventServiceAdmin.class);
        if (this.eventAdmin != null) {
            if (this.bulkMode) {
                this.eventAdmin.setBulkModeEnabled(true);
            }
            if (this.blockMimeTypeDetection) {
                this.eventAdmin.setListenerEnabledFlag(MIME_LISTENER, false);
            }
            if (this.blockNotifications) {
                this.eventAdmin.setListenerEnabledFlag(NOTIF_LISTENER, false);
            }
            if (this.blockAsyncProcessing) {
                this.eventAdmin.setBlockAsyncHandlers(true);
            } else {
                this.eventAdmin.setBlockAsyncHandlers(false);
            }
            if (this.blockSyncPostCommitProcessing) {
                this.eventAdmin.setBlockSyncPostCommitHandlers(true);
            } else {
                this.eventAdmin.setBlockSyncPostCommitHandlers(false);
            }
        } else {
            log.warn((Object)"EventServiceAdmin service was not found ... Possible that the import process will not proceed ok");
        }
    }

    @Override
    public void handleAfterImport(Exception e) {
        if (this.eventAdmin != null) {
            this.eventAdmin.setBulkModeEnabled(false);
            this.eventAdmin.setBlockAsyncHandlers(false);
            this.eventAdmin.setBlockSyncPostCommitHandlers(false);
            this.eventAdmin.setListenerEnabledFlag(NOTIF_LISTENER, true);
            this.eventAdmin.setListenerEnabledFlag(MIME_LISTENER, true);
        }
        this.eventAdmin = null;
    }

    public boolean getBlockNotifications() {
        return this.blockNotifications;
    }

    public void setBlockNotifications(boolean blockNotifications) {
        this.blockNotifications = blockNotifications;
    }

    public String toString() {
        return String.format("blockSyncPostCommitProcessing set %b, blockAsyncProcessing set %b, blockMimeTypeDetection set %b and blockNotifications set %b", this.blockSyncPostCommitProcessing, this.blockAsyncProcessing, this.blockMimeTypeDetection, this.blockNotifications);
    }
}

