/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.log.ImporterLogger;
import org.nuxeo.ecm.platform.importer.service.DefaultImporterService;
import org.nuxeo.ecm.platform.importer.service.DefaultImporterServiceImpl;
import org.nuxeo.ecm.platform.importer.service.ImporterConfigurationDescriptor;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DefaultImporterComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(DefaultImporterComponent.class);
    protected DefaultImporterService importerService;
    public static final String IMPORTER_CONFIGURATION_XP = "importerConfiguration";
    public static final String DEFAULT_FOLDERISH_DOC_TYPE = "Folder";
    public static final String DEFAULT_LEAF_DOC_TYPE = "File";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (IMPORTER_CONFIGURATION_XP.equals(extensionPoint)) {
            ImporterConfigurationDescriptor descriptor = (ImporterConfigurationDescriptor)contribution;
            Class<Object> sourceNodeClass = descriptor.getSourceNodeClass();
            if (sourceNodeClass == null) {
                sourceNodeClass = FileSourceNode.class;
                log.info((Object)"No custom implementation defined for the SourceNode, using FileSourceNode");
            }
            this.importerService.setSourceNodeClass(sourceNodeClass);
            Class<? extends DefaultDocumentModelFactory> docFactoryClass = descriptor.getDocumentModelFactory().getDocumentModelFactoryClass();
            if (docFactoryClass == null) {
                docFactoryClass = DefaultDocumentModelFactory.class;
                log.info((Object)"No custom implementation provided for the documentModelFactory, using DefaultDocumentModelFactory");
            }
            this.importerService.setDocModelFactoryClass(docFactoryClass);
            String folderishType = descriptor.getDocumentModelFactory().getFolderishType();
            if (folderishType == null) {
                folderishType = DEFAULT_FOLDERISH_DOC_TYPE;
                log.info((Object)"No folderish type defined, using Folder by default");
            }
            this.importerService.setFolderishDocType(folderishType);
            String leafType = descriptor.getDocumentModelFactory().getLeafType();
            if (leafType == null) {
                leafType = DEFAULT_LEAF_DOC_TYPE;
                log.info((Object)"No leaf type doc defined, using File by deafult");
            }
            this.importerService.setLeafDocType(leafType);
            Class<? extends ImporterLogger> logClass = descriptor.getImporterLog();
            if (logClass == null) {
                log.info((Object)"No specific ImporterLogger configured for this importer");
            } else {
                this.importerService.setImporterLogger(logClass.newInstance());
            }
        }
    }

    public void activate(ComponentContext context) throws Exception {
        this.importerService = new DefaultImporterServiceImpl();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.importerService = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(DefaultImporterService.class)) {
            return adapter.cast(this.importerService);
        }
        return (T)super.getAdapter(adapter);
    }
}

